---
title: MessageChannel and MessagePort · Changelog
description: The MessageChannel and MessagePort APIs are now available in Workers
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-08-11-messagechannel/
  md: https://developers.cloudflare.com/changelog/2025-08-11-messagechannel/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## MessageChannel and MessagePort

Aug 11, 2025

[Workers](https://developers.cloudflare.com/workers/)

A minimal implementation of the [MessageChannel API](https://developer.mozilla.org/en-US/docs/Web/API/MessageChannel) is now available in Workers. This means that you can use `MessageChannel` to send messages between different parts of your Worker, but not across different Workers.

The `MessageChannel` and `MessagePort` APIs will be available by default at the global scope with any worker using a compatibility date of `2025-08-15` or later. It is also available using the `expose_global_message_channel` compatibility flag, or can be explicitly disabled using the `no_expose_global_message_channel` compatibility flag.

```js
const { port1, port2 } = new MessageChannel();


port2.onmessage = (event) => {
  console.log('Received message:', event.data);
};


port2.postMessage('Hello from port2!');
```

Any value that can be used with the `structuredClone(...)` API can be sent over the port.

#### Differences

There are a number of key limitations to the `MessageChannel` API in Workers:

* Transfer lists are currently not supported. This means that you will not be able to transfer ownership of objects like `ArrayBuffer` or `MessagePort` between ports.
* The `MessagePort` is not yet serializable. This means that you cannot send a `MessagePort` object through the `postMessage` method or via JSRPC calls.
* The `'messageerror'` event is only partially supported. If the `'onmessage'` handler throws an error, the `'messageerror'` event will be triggered, however, it will not be triggered when there are errors serializing or deserializing the message data. Instead, the error will be thrown when the `postMessage` method is called on the sending port.
* The `'close'` event will be emitted on both ports when one of the ports is closed, however it will not be emitted when the Worker is terminated or when one of the ports is garbage collected.
