---
title: Content type returned in Workers Assets for Javascript files is now
  `text/javascript` · Changelog
description: Updated JavaScript asset responses to use the standardized
  text/javascript Content-Type header (previously `application/javascript`) for
  better alignment with the HTML spec and browser expectations.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-08-25-workers-assets-javascript-content-type/
  md: https://developers.cloudflare.com/changelog/2025-08-25-workers-assets-javascript-content-type/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Content type returned in Workers Assets for Javascript files is now \`text/javascript\`

Aug 25, 2025

[Workers](https://developers.cloudflare.com/workers/)

JavaScript asset responses have been updated to use the `text/javascript` Content-Type header instead of `application/javascript`. While both MIME types are widely supported by browsers, the HTML Living Standard explicitly recommends `text/javascript` as the preferred type going forward.

This change improves:

* Standards alignment: Ensures consistency with the HTML spec and modern web platform guidance.
* Interoperability: Some developer tools, validators, and proxies expect text/javascript and may warn or behave inconsistently with application/javascript.
* Future-proofing: By following the spec-preferred MIME type, we reduce the risk of deprecation warnings or unexpected behavior in evolving browser environments.
* Consistency: Most frameworks, CDNs, and hosting providers now default to text/javascript, so this change matches common ecosystem practice.

Because all major browsers accept both MIME types, this update is backwards compatible and should not cause breakage.

Users will see this change on the next deployment of their assets.
