---
title: API and Terraform · Cloudflare Zero Trust docs
description: This section covers a few common use cases with the API and
  Terraform to manage Cloudflare Zero Trust. For more information, refer to our
  API documentation and Terraform reference guide.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/api-terraform/
  md: https://developers.cloudflare.com/cloudflare-one/api-terraform/index.md
---

This section covers a few common use cases with the API and Terraform to manage Cloudflare Zero Trust. For more information, refer to our [API documentation](https://developers.cloudflare.com/api/) and [Terraform reference guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs).

* [Access API examples](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-api-examples/)
* [Terraform](https://developers.cloudflare.com/cloudflare-one/api-terraform/access-with-terraform/)

## Set dashboard to read-only

Super Administrators can lock all settings as read-only in Zero Trust. Read-only mode ensures that all updates for the account are made through the API or Terraform.

To enable read-only mode:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Account**.
2. Enable **API/Terraform read-only mode**.

All users, regardless of [user permissions](https://developers.cloudflare.com/cloudflare-one/roles-permissions/), will be prevented from making configuration changes through the UI.

## Scoped API tokens

The administrators managing policies and groups in Cloudflare Zero Trust might be different from those responsible for configuring WAF custom rules or other Cloudflare settings. You can configure scoped API tokens so that team members and automated systems can manage Zero Trust settings without having permission to modify other configurations in Cloudflare.

You can create a scoped API token [via the dashboard](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) or [via the API](https://developers.cloudflare.com/fundamentals/api/how-to/create-via-api/). For a list of available token permissions, refer to [API token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/).
