---
title: Secure a private IP or hostname · Cloudflare Zero Trust docs
description: You can configure a self-hosted Access application to manage access
  to specific IPs or hostnames on your private network.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/applications/non-http/self-hosted-private-app/
  md: https://developers.cloudflare.com/cloudflare-one/applications/non-http/self-hosted-private-app/index.md
---

You can configure a self-hosted Access application to manage access to specific IPs or hostnames on your private network.

Note

This feature replaces the legacy [private network app type](https://developers.cloudflare.com/cloudflare-one/applications/non-http/legacy-private-network-app/).

## Prerequisites

* Private IPs and hostnames are reachable over Cloudflare WARP, Magic WAN or Browser Isolation. For more details, refer to [Connect a private network](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/).
* Private hostnames route to your custom DNS resolver through [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/) or [Gateway resolver policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/resolver-policies/).
* Public IPs and hostnames can be used to define a private application, however the IP or hostname must route through Cloudflare via [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/), [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/), or [Magic WAN](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/).
* (Optional) Turn on [Gateway TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/) if you want to use Access JWTs to manage [HTTPS application sessions](#https-applications).

## Add your application to Access

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Select **Add an application**.

3. Select **Self-hosted**.

4. Enter any name for the application.

5. In **Session Duration**, choose how often the user's [application token](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/application-token/) should expire.

   Cloudflare checks every HTTP request to your application for a valid application token. If the user's application token (and global token) has expired, they will be prompted to reauthenticate with the IdP. For more information, refer to [Session management](https://developers.cloudflare.com/cloudflare-one/identity/users/session-management/).

   If the application is non-HTTPS or you do not have TLS decryption turned on, the session is tracked by the WARP client per application.

1) Add the private IP and/or private hostname that represents the application. You can use [wildcards](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/app-paths/) with private hostnames to protect multiple parts of an application that share a root path.

   Note

   Private hostnames are currently only available over port `443` over HTTPS and the application must have a valid Server Name Indicator (SNI). If you are configuring a private IP on any port other than `443` and plan to use Browser Isolation, note that this [will result in a Gateway block page](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/known-limitations/#browser-isolation-is-not-compatible-with-private-ips-on-non-443-ports).

2) Add [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) to control who can connect to your application. All Access applications are deny by default -- a user must match an Allow policy before they are granted access.

3) Configure how users will authenticate:

   1. Select the [**Identity providers**](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/) you want to enable for your application.
   2. (Recommended) If you plan to only allow access via a single IdP, turn on **Instant Auth**. End users will not be shown the [Cloudflare Access login page](https://developers.cloudflare.com/cloudflare-one/applications/login-page/). Instead, Cloudflare will redirect users directly to your SSO login event.
   3. (Recommended) Turn on **WARP authentication identity** to allow users to authenticate to the application using their [WARP session identity](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/). We recommend turning this on if your application is not in the browser and cannot handle a `302` redirect.

4) Select **Next**.

5) (Optional) Configure [App Launcher settings](https://developers.cloudflare.com/cloudflare-one/applications/app-launcher/) for the application.

6) Under **Block page**, choose what end users will see when they are denied access to the application:

   * **Cloudflare default**: Reload the [login page](https://developers.cloudflare.com/cloudflare-one/applications/login-page/) and display a block message below the Cloudflare Access logo. The default message is `That account does not have access`, or you can enter a custom message.
   * **Redirect URL**: Redirect to the specified website.
   * **Custom page template**: Display a [custom block page](https://developers.cloudflare.com/cloudflare-one/applications/block-page/) hosted in Zero Trust.

7) Select **Next**.

8) (Optional) Configure advanced settings:

   * [**Cross-Origin Resource Sharing (CORS) settings**](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/cors/)
   * [**Cookie settings**](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/#cookie-settings)
   * **401 Response for Service Auth policies**: Return a `401` response code when a user (or machine) makes a request to the application without the correct [service token](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/).

   These settings only apply to private hostnames and require [Gateway TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/).

9) Select **Save**.

Users can now connect to your private application after authenticating with Cloudflare Access.

## Authentication flow

### HTTPS applications

If [Gateway TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/) is turned on and a user is accessing an HTTPS application on port `443`, Cloudflare Access will present a login page in the browser and issue an [application token](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/application-token/) to your origin. This is the same cookie-based authentication flow used by [self-hosted public apps](https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/self-hosted-public-app/).

If [Gateway TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/) is turned off, session management is [handled in the WARP client](#non-https-applications) instead of in the browser.

### Non-HTTPS applications

The WARP client manages sessions for all non-HTTPS applications. Users will receive an `Authentication required` pop-up notification from the WARP client. When the user selects the notification, WARP will open a browser window with your Access login page.

Ensure that your operating system allows notifications for WARP. Your device may not display notifications if focus, do not disturb, or screen sharing settings are turned on. To turn on client notifications on macOS devices running DisplayLink software, you may have to allow system notifications when mirroring your display. For more information, refer to the [macOS documentation](https://support.apple.com/guide/mac-help/change-notifications-settings-mh40583/mac).

## Order of precedence

### Access vs Gateway policies

By default, Cloudflare will evaluate Access application policies after evaluating all Gateway network policies. To evaluate Access applications before or after specific Gateway policies:

1. Create the following [Gateway network policy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/):

   | Selector | Operator | Value | Action |
   | - | - | - | - |
   | Access Private App | is | *Present* | Allow |

2. Update the policy's [order of precedence](https://developers.cloudflare.com/cloudflare-one/traffic-policies/order-of-enforcement/#order-of-precedence) using the dashboard or API.

Note

Users must pass the policies in your Access application before they are granted access. The Gateway Allow policy is strictly for routing and connectivity purposes.

### Private hostname vs private IP

An Access application defined by a private hostname takes precedence over an Access application defined by a private IP. For example, assume App-1 points to `wiki.internal.local` and App-2 points to `10.0.0.1`, but `wiki.internal.local` resolves to `10.0.0.1`. Users who go to `wiki.internal.local` will never match App-2; they will be allowed or blocked strictly based on App-1 Access policies (and [Gateway policies](#access-vs-gateway-policies)).
