---
title: Phish submissions · Cloudflare Zero Trust docs
description: As part of your continuous email security posture, administrators
  and security analysts need to submit missed phishing samples to Email
  Security, so Cloudflare can process them and take necessary action.
lastUpdated: 2025-07-28T14:44:01.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/phish-submissions/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/phish-submissions/index.md
---

As part of your continuous email security posture, administrators and security analysts need to submit missed phishing samples to Email Security, so Cloudflare can process them and take necessary action.

Submitting missed phish samples to Cloudflare is of paramount importance and necessary for continuous protection. Submitting missed phish samples helps Cloudflare improve our machine learning (ML) models, and alerts us of new attack vectors before they become prevalent.

There are three routes you can use to report an email as a phish:

* Via Investigation, by [reclassifying an email](https://developers.cloudflare.com/cloudflare-one/email-security/phish-submissions/#reclassify-an-email).
* Via [PhishNet M365](https://developers.cloudflare.com/cloudflare-one/email-security/phish-submissions/#phishnet-m365) or [PhishNet for Google Workspace](https://developers.cloudflare.com/cloudflare-one/email-security/phish-submissions/#phishnet-for-google-workspace), depending on your email provider.
* Via [Submission addresses](https://developers.cloudflare.com/cloudflare-one/email-security/phish-submissions/#submission-addresses).

## Reclassify an email

1. Log in to [Zero Trust](https://one.dash.cloudflare.com/).
2. Select **Email Security** > **Investigation**.
3. On the **Investigation** page, under **Your matching messages**, select the message you want to reclassify. Select the three dots, then select **Request reclassification**. By selecting **Request reclassification**, you are requesting a new disposition for the message.
4. Select the new disposition, then select **Save**.

When you report an email as phish, this email will be displayed under [User submissions](https://developers.cloudflare.com/cloudflare-one/email-security/email-monitoring/search-email/#user-submissions).

## PhishNet M365

PhishNet is an add-in button that helps users to submit directly to Email Security phish samples missed by Email Security's detection.

To set up PhishNet M365:

1. Get the customized manifest URL from [Zero Trust](https://one.dash.cloudflare.com/?to=/:account/email-security/settings/email-policy/phish-submission?tab=phish-submission).
2. Log in to the [Microsoft admin panel](https://admin.microsoft.com/).
3. Go to **Microsoft 365 admin center** > **Settings** > **Integrated Apps**.
4. Select **Upload custom apps**.
5. Choose **Provide link to manifest file** and paste the URL you copied from the Zero Trust dashboard.
6. Verify and complete the wizard.

## PhishNet for Google Workspace

To set up PhishNet with Google Workspace you need admin access to your Google Workspace account.

### Set up PhishNet for Google Workspace

1. Log in to [Google Workspace Marketplace apps](https://workspace.google.com/marketplace/app/cloudflare_phishnet/11369379045) using this direct link and an administrator account.
2. Select **Admin install** to install Cloudflare PhishNet. Read the warning, and select **Continue**.
3. You will be redirected to the **Allow data access** page, where you can choose to install Cloudflare PhishNet for **Everyone at your organization**, or **Certain groups or organizational units**. If you choose the latter option, you will have to select the users in the next step.
4. After choosing the groups you want to install PhishNet for, agree with Google's terms of service, and select **Finish**.
5. Cloudflare PhishNet has been installed. Select **DONE**.

You have now successfully installed Cloudflare PhishNet.

### Submit phish with PhishNet

1. In your Gmail web client, open the message you would like to flag as either spam or phish.
2. Select the PhishNet logo on the side panel.
3. Under **Select Submission Type**, select **Spam** or **Phish**.
4. Select **Submit Report**.

## Submission addresses

To view the destination addresses of user and team submissions:

1. Log in to [Zero Trust](https://one.dash.cloudflare.com/).
2. Select **Email Security**.
3. Select **Settings**.
4. Go to **Phish submission** > **Submission addresses** > **View**.

The dashboard will display **User submission addresses** and **Team submission addresses**.
