---
title: Integrate Tanium with Access · Cloudflare Zero Trust docs
description: Cloudflare Access can use endpoint data from Tanium™ to determine
  if a request should be allowed to reach a protected resource. When users
  attempt to connect to a resource protected by Access with a Tanium rule,
  Cloudflare Access will validate the user's identity, and the browser will
  connect to the Tanium agent before making a decision to grant access.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/access-integrations/tanium/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/access-integrations/tanium/index.md
---

Note

Not recommended for new deployments. We recommend using the [Tanium service-to-service integration](https://developers.cloudflare.com/cloudflare-one/identity/devices/service-providers/taniums2s/) to get device posture signals from Tanium.

Cloudflare Access can use endpoint data from [Tanium™](https://www.tanium.com/) to determine if a request should be allowed to reach a protected resource. When users attempt to connect to a resource protected by Access with a Tanium rule, Cloudflare Access will validate the user's identity, and the browser will connect to the Tanium agent before making a decision to grant access.

Gateway device posture limitation

The Tanium integration cannot be used with [Gateway device posture policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/#device-posture).

## Prerequisites

* Tanium Core Platform version 7.2 or later

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [Access integrations](https://developers.cloudflare.com/cloudflare-one/identity/devices/access-integrations/).

## Integrate Tanium with Cloudflare Access

Note

The integration does not currently support Safari.

1. Configure your Tanium deployment using the [step-by-step documentation](https://docs.tanium.com/endpoint_identity/endpoint_identity/userguide.html) provided. You will need the public key to integrate your Tanium deployment with Cloudflare Access.

2. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.

3. Scroll down to **WARP client checks** and select **Add new**.

4. Select **Tanium** from the list of providers.

5. Enter any **Name** for the integration.

6. For **Port**, enter `17472`.

   This is the default port used by the Tanium endpoints to communicate inbound and outbound with Cloudflare Access. You may need to modify it to reflect your organization's deployment.

7. Input the public certificate generated in Step 1.

   Adding the certificate allows Cloudflare to validate that the response from the Tanium agent is valid.

You can now build [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) that check [device posture signals](#tanium-endpoint-signals) from the Tanium endpoint.

## Example Access policy

This example will only grant access to users who are part of your team's email domain and running the Tanium agent.

| Action | Rule type | Selector | Value |
| - | - | - | - |
| Allow | Include | Emails Ending in | `@team.com` |
| | Require | Device Posture - Tanium | `Managed` |

The Tanium rule will require that the device connecting is managed in your Tanium deployment and has checked into the Tanium server in the last 7 days.

## Tanium endpoint signals

| Signal | Value | Description |
| - | - | - |
| Managed | Boolean | Validates that the device is managed in your organization's Tanium account. |
