---
title: Kolide · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust can integrate with Kolide to require that
  users connect to certain applications from managed devices. This
  service-to-service posture check uses the WARP client to read endpoint data
  from Kolide. Devices are identified by their serial numbers. If multiple
  devices have the same serial number, Cloudflare cannot accurately match a WARP
  device with a third-party provider device. You must ensure that each of your
  devices has a unique serial number.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/service-providers/kolide/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/service-providers/kolide/index.md
---

Cloudflare Zero Trust can integrate with Kolide to require that users connect to certain applications from managed devices. This service-to-service posture check uses the WARP client to read endpoint data from Kolide. Devices are identified by their serial numbers. If multiple devices have the same serial number, Cloudflare cannot accurately match a WARP device with a third-party provider device. You must ensure that each of your devices has a unique serial number.

## Prerequisites

* Kolide agent is deployed on the device.

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [Service providers](https://developers.cloudflare.com/cloudflare-one/identity/devices/service-providers/).

## Set up Kolide as a service provider

### 1. Create a Client Secret in Kolide

1. Log in to your Kolide dashboard.
2. Select your profile and go to **Settings** > **Developers**.
3. Select **Create New Key**.
4. Enter a **Key Name** and select **Save**.
5. Copy the **Secret token** to a safe place. This will be your Client Secret.

### 2. Add Kolide as a service provider

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client**.
2. Scroll down to **Third-party service provider integrations** and select **Add new**.
3. Select **Kolide**.
4. Enter any name for the provider. This name will be used throughout the dashboard to reference this connection.

1) Enter the **Client secret** you noted down above.
2) Choose a **Polling frequency** for how often Cloudflare Zero Trust should query Kolide for information.
3) Select **Test and save**.

### 3. Configure the posture check

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client** > **Service provider checks**.
2. Select **Add new**.
3. Select the Kolide provider.
4. Enter any name for the posture check.
5. Configure the [attributes](#device-posture-attributes) required for the device to pass the posture check.
6. Select **Save**.
7. To test, go to **Logs** > **Posture** and verify that the service provider posture check is returning the expected results.

You can now use this posture check in a [device posture policy](https://developers.cloudflare.com/cloudflare-one/identity/devices/#3-build-a-device-posture-policy).

## Device posture attributes

Device posture data is gathered from the [Kolide K2 API](https://kolidek2.readme.io/reference/get_issues).

| Selector | Description |
| - | - |
| Issue count | Total number of issues detected on the device |
