---
title: Microsoft Entra ID · Cloudflare Zero Trust docs
description: You can integrate Microsoft Entra ID (formerly Azure Active
  Directory) with Cloudflare Zero Trust and build policies based on user
  identity and group membership. Users will authenticate to Zero Trust using
  their Entra ID credentials.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/index.md
---

You can integrate Microsoft Entra ID (formerly Azure Active Directory) with Cloudflare Zero Trust and build policies based on user identity and group membership. Users will authenticate to Zero Trust using their Entra ID credentials.

## Set up Entra ID as an identity provider

### 1. Obtain Entra ID settings

The following Entra ID values are required to set up the integration:

* Application (client) ID
* Directory (tenant) ID
* Client secret

To retrieve those values:

1. Log in to the [Microsoft Entra admin center](https://entra.microsoft.com/).

2. Go to **Applications** > **Enterprise applications**.

3. Select **New application**, then select **Create your own application**.

4. Name your application.

5. Select **Register an application to integrate with Microsoft Entra ID (App you're developing)**. If offered, do not select any of the gallery applications. Select **Create**.

6. Under **Redirect URI**, select the *Web* platform and enter the following URL.

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
   ```

   In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Custom Pages** to find your team name.

   ![Registering an application in Azure](https://developers.cloudflare.com/_astro/name-app.BaJD5DTz_llkEb.webp)

7. Select **Register**.

8. Next, return to Microsoft Entra ID and go to **Applications** > **App registrations**.

9. Select **All applications** and select the app you just created. Copy the **Application (client) ID** and **Directory (tenant) ID**. You will need these values when [adding Entra ID as an identity provider in step 3](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#3-add-entra-id-as-an-identity-provider).

   ![Viewing the Application ID and Directory ID in Azure](https://developers.cloudflare.com/_astro/azure-values.BIjGV_0A_Z1Eu7vp.webp)

10. On the same page, under **Client credentials**, go to **Add a certificate or secret**. Select **New client secret**.

11. Name the client secret and choose an expiration period.

    Note

    When the client secret expires, users will be unable to log in through Access. Take note of your expiry date to prevent login errors and renew your client secret when necessary.

12. After the client secret is created, copy its **Value** field. Store the client secret in a safe place, as it can only be viewed immediately after creation. You will need this client secret value when [adding Entra ID as an identity provider in step 3](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#3-add-entra-id-as-an-identity-provider).

    ![Location of client secret in Azure](https://developers.cloudflare.com/_astro/client-cert-value.BgU55T2B_ZaqOUk.webp)

### 2. Configure API permissions in Entra ID

1. Go to **App registrations** > **All applications** > select your application > **API permissions**.

2. Select **Add a permission**.

3. Select **Microsoft Graph**.

4. Select **Delegated permissions** and enable the following [permissions](https://learn.microsoft.com/graph/permissions-reference):

   * `email`
   * `offline_access`
   * `openid`
   * `profile`
   * `User.Read`
   * `Directory.Read.All`
   * `GroupMember.Read.All`

Note

More narrow permissions may be used, however this is the set of permissions that are tested and supported by Cloudflare.

1. Once all seven permissions are enabled, select **Add permissions**.

2. Select **Grant admin consent**.

   ![Configured permissions list in Azure](https://developers.cloudflare.com/_astro/configured-perms.C3NcHNrM_Z1WCyL8.webp)

### 3. Add Entra ID as an identity provider

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.

  2. Under **Login methods**, select **Add new**.

  3. Select **Azure AD**.

  4. Enter the **Application (client) ID**, **Client secret**, and **Directory (tenant) ID** obtained from Microsoft Entra ID.

  5. Select **Save**.

  6. To [test](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/#test-idps-in-zero-trust) that your connection is working, select **Test**.

  7. (Optional) Configure the following settings:

     * **Proof Key for Code Exchange**: Perform [PKCE](https://www.oauth.com/oauth2-servers/pkce/) on all login attempts.
     * **Support Groups**: Allow Cloudflare to read a user's Entra ID group membership.
     * **Entra ID Policy Sync**: Refer to our [Entra ID Conditional Access tutorial](https://developers.cloudflare.com/cloudflare-one/tutorials/entra-id-conditional-access/).
     * **Enable SCIM**: Refer to [Synchronize users and groups](#synchronize-users-and-groups).
     * **Email claim**: Enter the Entra ID claim that you wish to use for user identification (for example, `preferred_username`).
     * **OIDC Claims**: Enter [custom OIDC claims](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/#custom-oidc-claims) that you wish to add to your users' identity.

* API

  Make a `POST` request to the [Identity Providers](https://developers.cloudflare.com/api/resources/zero_trust/subresources/identity_providers/methods/create/) endpoint:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Access: Organizations, Identity Providers, and Groups Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/access/identity_providers" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "name": "Entra ID example",
      "type": "azureAD",
      "config": {
          "client_id": "<your client id>",
          "client_secret": "<your client secret>",
          "directory_id": "<your azure directory uuid>",
          "support_groups": true
      }
    }'
  ```

* Terraform

  Provider versions

  The following example requires Cloudflare provider version `4.40.0` or greater.

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Access: Organizations, Identity Providers, and Groups Write`

  2. Configure the [`cloudflare_zero_trust_access_identity_provider`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_access_identity_provider) resource:

     ```tf
     resource "cloudflare_zero_trust_access_identity_provider" "microsoft_entra_id" {
       account_id = var.cloudflare_account_id
       name       = "Entra ID example"
       type       = "azureAD"
       config      = {
         client_id                  = var.entra_id_client_id
         client_secret              = var.entra_id_client_secret
         directory_id               = var.entra_id_directory_id
         support_groups             = true
         }
     }
     ```

#### UPN and email

If your organization's UPNs do not match users' email addresses, you must add a custom claim for email. For example, if your organization's email format is `user@domain.com` but the UPN is `u908080@domain.com`, you must create an email claim if you are configuring email-based policies.

By default, Cloudflare will first look for the unique claim name you created and configured in Zero Trust to represent email (for example, `email_identifier`) in the `id_token` JSON response. If you did not configure a unique claim name, Cloudflare will then look for an `email` claim. Last, if neither claim exists, Cloudflare will look for the UPN claim.

To receive an email claim in the `id_token` from Microsoft Entra, you must:

1. In the [Microsoft Entra admin center](https://entra.microsoft.com/), go to **Application** > **App registration** > **All applications** > select the relevant application > under **Manage**, select **Token configuration**.

2. Add a claim for email.

   ![Email claim for Entra](https://developers.cloudflare.com/_astro/entra-email-claim.CPt-1jZE_121z85.webp)

   The example above includes both a UPN claim and an email claim. Because an email claim was created in the Microsoft Entra configuration, Cloudflare will look for the `email` key-value pair in the JSON response.

3. If you gave your email claim another name than `email`, you must update your configuration in Zero Trust:

   a. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication** > **Azure AD** > **Edit**.

   b. Under **Optional configurations** > **Email claim**, enter the name of the claim representing your organization's email addresses.

#### Object ID

If you are concerned that users' emails or UPNs may change, you can pass the user's object ID (`oid`) from Microsoft Entra to Cloudflare Access. To configure Access to receive the object ID, refer to [custom OIDC claims](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-oidc/#custom-oidc-claims). No additional configuration is required in Microsoft Entra.

## Synchronize users and groups

The Microsoft Entra ID integration allows you to synchronize IdP groups and automatically deprovision users using [SCIM](https://developers.cloudflare.com/cloudflare-one/identity/users/scim/).

### Prerequisites

* Microsoft Entra ID P1 or P2 license

### 1. Enable SCIM in Zero Trust

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.

2. Find the Entra ID integration and select **Edit**.

3. Turn on **Enable SCIM** and **Support groups**.

4. (Optional) Configure the following settings:

* **Enable user deprovisioning**: [Revoke a user's active session](https://developers.cloudflare.com/cloudflare-one/identity/users/session-management/#per-user) when they are removed from the SCIM application in Entra ID. This will invalidate all active Access sessions and prompt for reauthentication for any [WARP session policies](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/).

* **Remove user seat on deprovision**: [Remove a user's seat](https://developers.cloudflare.com/cloudflare-one/identity/users/seat-management/) from your Zero Trust account when they are removed from the SCIM application in Entra ID.

* **SCIM identity update behavior**: Choose what happens in Zero Trust when the user's identity updates in Entra ID.

  * *Automatic identity updates*: Automatically update the [User Registry identity](https://developers.cloudflare.com/cloudflare-one/insights/logs/users/) when Entra ID sends an updated identity or group membership through SCIM. This identity is used for Gateway policies and WARP [device profiles](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/); Access will read the user's updated identity when they reauthenticate.
  * *Group membership change reauthentication*: [Revoke a user's active session](https://developers.cloudflare.com/cloudflare-one/identity/users/session-management/#per-user) when their group membership changes in Entra ID. This will invalidate all active Access sessions and prompt for reauthentication for any [WARP session policies](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/). Access will read the user's updated group membership when they reauthenticate.
  * *No action*: Update the user's identity the next time they reauthenticate to Access or WARP.

1. Select **Regenerate Secret**. Copy the **SCIM Endpoint** and **SCIM Secret**. You will need to enter these values into Entra ID.

2. Select **Save**.

The SCIM secret never expires, but you can manually regenerate the secret at any time.

### 2. Configure SCIM in Entra ID

Note

SCIM requires a separate enterprise application from the one created during [initial setup](#set-up-entra-id-as-an-identity-provider).

1. In the Microsoft Entra ID menu, go to **Enterprise applications**.

2. Select **New application** > **Create your own application**.

3. Name your application (for example, `Cloudflare Access SCIM`).

4. Select **Integrate any other application you don't find in the gallery (Non-gallery)**. If offered, do not select any of the gallery applications. Select **Create**.

5. After you have created the application, go to **Provisioning** > select **New Configuration**.

6. In the **Tenant URL** field, enter the **SCIM Endpoint** obtained from your Entra ID integration in Zero Trust [in the previous step](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#1-enable-scim-in-zero-trust).

7. In the **Secret token** field, enter the **SCIM Secret** obtained from your Entra ID integration in Zero Trust [in the previous step](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#1-enable-scim-in-zero-trust).

8. Select **Test Connection** to ensure that the credentials were entered correctly. If the test fails, go to your Entra ID integration in Zero Trust, select **Regenerate Secret**, select **Save**, and enter your new **SCIM Secret** in the **Secret token** field.

9. Select **Create**.

10. Once the SCIM application is created, [assign users and groups to the application](https://learn.microsoft.com/entra/identity/enterprise-apps/assign-user-or-group-access-portal).

Note

Groups in this SCIM application should match the groups in your other [Cloudflare Access enterprise application](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#set-up-entra-id-as-an-identity-provider). Because SCIM group membership updates will overwrite any groups in a user's identity, assigning the same groups to each app ensures consistent policy evaluation.

1. Go to **Provisioning** and select **Start provisioning**.

2. For **Provisioning Mode**, the default mode should be set by Microsoft to *Automatic*.

3. On the **Overview** page in Entra ID, you will see the synchronization status.

To check which users and groups were synchronized, select **Provisioning logs**.

To check if user identities were updated in Zero Trust, view your [SCIM provisioning logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/scim-logs/).

Note

New users must first [register the WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/) or authenticate to an Access application before SCIM provisioning can begin.

To monitor the exchange of identity details between Cloudflare Access and Microsoft Entra ID, go to [Zero Trust](https://one.dash.cloudflare.com) > **Logs** > **SCIM provisioning** and view the [SCIM activity logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/scim-logs/).

### Provisioning attributes

Provisioning attributes define the user properties that Entra ID will synchronize with Cloudflare Access. To modify your provisioning attributes, go to the **Attribute mapping** and select **Provision Microsoft Entra ID Users**.

If not already configured, Cloudflare recommends enabling the following user attribute mappings:

| customappsso Attribute | Entra ID Attribute | Recommendation |
| - | - | - |
| `userName` | `userPrincipalName` or `mail` | Required. Must match the user's email address in Zero Trust. |
| `emails[type eq "work"].value` | `mail` | Required. Must match the user's email address in Zero Trust. |
| `name.givenName` | `givenName` | Recommended |
| `name.familyName` | `surname` | Recommended |

## Entra groups in Zero Trust policies

### Automatic entry

When [SCIM synchronization is enabled](#synchronize-users-and-groups), your Entra group names will automatically appear in the Access and Gateway policy builders.

![Azure group names displayed in the Access policy builder](https://developers.cloudflare.com/_astro/azure-scim-groups.CShvL-AY_Z13loiJ.webp)

If building a Gateway policy, choose the [*User Group Names*](https://developers.cloudflare.com/cloudflare-one/traffic-policies/identity-selectors/#user-group-names) selector.

### Manual entry

You can create Access and Gateway policies for groups that are not synchronized with SCIM. Entra ID exposes directory groups in a format that consists of random strings, the `Object Id`, that is distinct from the `Name`.

1. Make sure you enable **Support groups** as you set up Microsoft Entra ID in Zero Trust.

2. In your Microsoft Entra dashboard, note the `Object Id` for the Entra group. In the example below, the group named Admins has an ID of `61503835-b6fe-4630-af88-de551dd59a2`.

   ![Viewing the Azure group ID on the Azure dashboard](https://developers.cloudflare.com/_astro/object-id.Cr5EOUSk_Z1y4aPG.webp)

3. If building an Access policy, choose the *Azure Groups* selector. If building a Gateway policy, choose the *User Group IDs* selector.

4. In the **Value** field, enter the `Object Id` for the Entra group.

   ![Entering an Azure group ID in Zero Trust](https://developers.cloudflare.com/_astro/configure-group-n.CdHBsLpw_Z1jU6Qs.webp)

### Nested groups

#### Authentication

Access and Gateway policies for an Entra group will also apply to all [nested groups](https://learn.microsoft.com/entra/fundamentals/how-to-manage-groups#add-a-group-to-another-group). For example, if a user belongs to the group `US devs`, and `US devs` is part of the broader group `Devs`, the user would be allowed or blocked by all policies created for `Devs`.

#### SCIM provisioning

For SCIM provisioning, [nested groups are not supported](https://learn.microsoft.com/en-us/entra/identity/app-provisioning/how-provisioning-works#assignment-based-scoping). Microsoft Entra ID's SCIM implementation does not send information about nested group memberships to Cloudflare. Only users who are direct members of an explicitly assigned group will be provisioned. To ensure group memberships are correctly synchronized, you must flatten your groups in Entra ID by directly assigning users to the groups you want to provision.

Since the SCIM request from Microsoft does not include nested group information, neither Cloudflare nor Microsoft can provide a notification that nested groups are not being synchronized.

## Force user interaction during WARP reauthentication

You can require users to re-enter their credentials into Entra ID whenever they [re-authenticate their WARP session](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/). To configure this setting:

1. Make a `GET` request to the [Identity Providers endpoint](https://developers.cloudflare.com/api/resources/zero_trust/subresources/identity_providers/) and copy the response for the Entra ID identity provider.

   Required API token permissions

   At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

   * `Access: Organizations, Identity Providers, and Groups Write`
   * `Access: Organizations, Identity Providers, and Groups Read`

   ```bash
   curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/access/identity_providers/$IDENTITY_PROVIDER_ID" \
     --request GET \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
   ```

2. [Update the Entra ID identity provider](https://developers.cloudflare.com/api/resources/zero_trust/subresources/identity_providers/methods/update/) using a `PUT` request. In the request body, include all existing configurations and set the `prompt` parameter to either `login` or `select_account`. For example:

   Required API token permissions

   At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

   * `Access: Organizations, Identity Providers, and Groups Write`

   ```bash
   curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/access/identity_providers/$IDENTITY_PROVIDER_ID" \
     --request PUT \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
     --json '{
       "id": "f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
       "type": "azureAD",
       "uid": "f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
       "name": "Entra ID",
       "version": "31e74e9b4f033e16b604552091a72295",
       "config": {
           "azure_cloud": "default",
           "client_id": "<CLIENT_ID>",
           "conditional_access_enabled": false,
           "directory_id": "<AZURE_DIRECTORY_ID>",
           "redirect_url": "https://<TEAM_NAME>.cloudflareaccess.com/cdn-cgi/access/callback",
           "prompt": "login",
           "support_groups": true
       },
       "scim_config": {
           "enabled": true,
           "user_deprovision": true,
           "seat_deprovision": false,
           "group_member_deprovision": false,
           "identity_update_behavior": "automatic"
       },
       "scim_base_url": "https://<TEAM_NAME>.cloudflareaccess.com/populations/f174e90a-fafe-4643-bbbc-4a0ed4fc8415/scim/v2"
     }'
   ```
