---
title: Published applications · Cloudflare Zero Trust docs
description: Cloudflare Tunnel allows you to publish local applications to the
  Internet via a public hostname. For example, you can add a published
  application route that points docs.example.com to https://localhost:8080.
  Anyone can now view your application by going to docs.example.com in their web
  browser.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/index.md
---

Cloudflare Tunnel allows you to publish local applications to the Internet via a public hostname. For example, you can [add a published application route](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/get-started/create-remote-tunnel/#2a-publish-an-application) that points `docs.example.com` to `https://localhost:8080`. Anyone can now view your application by going to `docs.example.com` in their web browser.

Cloudflare can route traffic down your Cloudflare Tunnel using a [DNS record](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/dns/) or [Cloudflare Load Balancer](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/public-load-balancers/). You can configure either option from the Cloudflare dashboard by pointing a DNS `CNAME` record or a load balancer pool to your Cloudflare Tunnel subdomain (`<UUID>.cfargotunnel.com`). You can also associate these records with your tunnel from `cloudflared` directly.

Note

You do not need a paid Cloudflare Access plan to publish an application via Cloudflare Tunnel. [Access seats](https://developers.cloudflare.com/cloudflare-one/identity/users/seat-management/) are only required if you want to [secure the application using Access policies](https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/self-hosted-public-app/), such as requiring users to log in via an identity provider.
