---
title: Use Microsoft Entra ID Conditional Access policies in Cloudflare Access ·
  Cloudflare Zero Trust docs
description: With Conditional Access in Microsoft Entra ID, administrators can
  enforce policies on applications and users directly in EntraID.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/tutorials/entra-id-conditional-access/
  md: https://developers.cloudflare.com/cloudflare-one/tutorials/entra-id-conditional-access/index.md
---

With [Conditional Access](https://learn.microsoft.com/entra/identity/conditional-access/overview) in Microsoft Entra ID (formerly Azure Active Directory), administrators can enforce policies on applications and users directly in Entra ID. Conditional Access has a set of checks that are specialized to Windows and are often preferred by organizations with Windows power users.

## Before you begin

Make sure you have:

* Global admin rights to Microsoft Entra ID account
* Configured users in the Microsoft Entra ID account

## Set up an identity provider for your application

Refer to [our IdP setup instructions](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#set-up-entra-id-as-an-identity-provider) for Entra ID.

## Add API permission in Entra ID

Once the base IdP integration is tested and working, grant permission for Cloudflare to read Conditional Access policies from Entra ID.

1. In Microsoft Entra ID, go to **App registrations**.

2. Select the application you created for the IdP integration.

3. Go to **API permissions** and select **Add a permission**.

4. Select **Microsoft Graph**.

5. Select **Application permissions** and add `Policy.Read.ConditionalAccess`.

   Note

   You must select **Application permissions**; delegated permissions will not work for this feature.

6. Select **Grant admin consent**.

## Configure Conditional Access in Entra ID

1. In Microsoft Entra ID, go to **Enterprise applications** > **Conditional Access**.

2. Go to **Authentication Contexts**.

3. [Create an authentication context](https://learn.microsoft.com/en-us/entra/identity/conditional-access/concept-conditional-access-cloud-apps#authentication-context) to reference in your Cloudflare Access policies. Give the authentication context a descriptive name (for example, `Require compliant devices`).

4. Next, go to **Policies**.

5. [Create a new Conditional Access policy](https://learn.microsoft.com/en-us/entra/identity/conditional-access/concept-conditional-access-policies) or select an existing policy.

6. Assign the conditional access policy to an authentication context:

   1. In the policy builder, select **Target resources**.
   2. In the **Select what this policy applies to** dropdown, select *Authentication context*.
   3. Select the authentication context that will use this policy.
   4. Save the policy.

## Sync Conditional Access with Zero Trust

To import your Conditional Access policies into Cloudflare Access:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.
2. Find your Microsoft Entra ID integration and select **Edit**.
3. Enable **Azure AD Policy Sync**.
4. Select **Save**.

## Create an Access application

To enforce your Conditional Access policies on a Cloudflare Access application:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Select **Add an application**.

3. Select **Self-hosted**.

4. Enter any name for the application.

5. Select **Add public hostname** and enter the target URL of the protected application.

6. Select **Create new policy** and build an [Access policy](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) using the *Azure AD - Auth context* selector. For example:

   | Action | Rule type | Selector | Value |
   | - | - | - | - |
   | Allow | Include | Emails ending in | `@example.com` |
   | | Require | Azure AD - Auth context | `Require compliant devices` |

7. Add this policy to your application configuration.

8. For **Identity providers**, select your Microsoft Entra ID integration.

9. Follow the remaining [self-hosted application creation steps](https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/self-hosted-public-app/) to publish the application.

Users will only be allowed access if they pass the Microsoft Entra ID Conditional Access policies associated with this authentication context.
