---
title: Batch record changes · Cloudflare DNS docs
description: Cloudflare allows you to apply several changes to your zone records
  in just one action. You can use the dashboard to delete DNS records or update
  their proxy status in bulk, or use the API to perform further batched
  operations.
lastUpdated: 2025-02-11T10:50:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/manage-dns-records/how-to/batch-record-changes/
  md: https://developers.cloudflare.com/dns/manage-dns-records/how-to/batch-record-changes/index.md
---

Cloudflare allows you to apply several changes to your zone records in just one action. You can [use the dashboard](#use-the-dashboard) to delete DNS records or update their proxy status in bulk, or [use the API](#use-the-api) to perform further batched operations.

Propagation through the Cloudflare network

Although Cloudflare will execute the batched operations in a single [database transaction](https://en.wikipedia.org/wiki/Database_transaction), Cloudflare's distributed KV store must treat each record change as a single key-value pair. This means that the propagation of changes is not atomic. Refer to our [blog post](https://blog.cloudflare.com/batched-dns-changes/) for details.

## Availability and limits

Batch DNS record changes is available on all plans.

The number of records that you can operate with in one action depends on your zone plan:

* Free: 200
* Pro: 3,500
* Business: 3,500
* Enterprise: 3,500

***

## Use the dashboard

### Edit proxy status in bulk

`A`,`AAAA`, and `CNAME` records can be [proxied](https://developers.cloudflare.com/dns/proxy-status/). The **Proxy status** of a DNS record affects [how Cloudflare responds to DNS queries](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/) to that record.

Note

If you have multiple `A/AAAA` records on the same name and at least one of them is proxied, Cloudflare will treat all `A/AAAA` records on this name as being proxied.

1. Go to [**DNS** > **Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records).
2. Select the DNS records you want to set the proxy status for. Note that only `A`, `AAAA`, and `CNAME` records can be proxied.
3. Select **Edit records**.
4. Choose the proxy status you want to apply to the selected records.
5. Select **Save** to confirm.

You can only set records to either **Proxied** or **DNS only** in bulk. This means that if your selection includes both proxied and DNS-only records, some of them will have the proxy status updated while others will keep their original value:

For example, if you select the following records and then edit their proxy status in bulk, choosing **Proxied** in [step 4 above](#edit-proxy-status-in-bulk), the outcome will be:

| Selected records | Original proxy status | Resulting proxy status |
| - | - | - |
| `www` | DNS only | Proxied |
| `blog` | DNS only | Proxied |
| `docs` | Proxied | Proxied |

### Delete records in bulk

Warning

Deleting DNS records can cause downtime and cannot be reverted. Make sure you only select DNS records that you can safely delete.

1. Go to [**DNS** > **Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records).
2. Select the DNS records you want to delete.
3. Select **Delete records**.
4. In the **Delete DNS records** prompt, type in `DELETE` and select **Delete** to confirm.

## Use the API

Note

This option requires familiarity with API usage and concepts. For further information about the Cloudflare API, refer to [Fundamentals](https://developers.cloudflare.com/fundamentals/api/get-started/).

The [Batched DNS record changes](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/batch/) endpoint allows you to trigger the execution of `DELETES`, `PATCHES`, `PUTS`, and `POSTS` in a single request.

[Tags and comments](https://developers.cloudflare.com/dns/manage-dns-records/reference/record-attributes/) are also supported with batch changes.

The operations you specify within the `/batch` request body are always executed in the following order:

1. Deletes
2. Patches
3. Puts
4. Posts

Within each of these four lists, each individual action is executed following the DNS records order you provide. If any of the individual action fails, no changes are applied and the API returns the first error it encountered.

### Aspects to consider

Propagation through the Cloudflare network

Although Cloudflare will execute the batched operations in a single [database transaction](https://en.wikipedia.org/wiki/Database_transaction), Cloudflare's distributed KV store must treat each record change as a single key-value pair. This means that the propagation of changes is not atomic. Refer to our [blog post](https://blog.cloudflare.com/batched-dns-changes/) for details.

For each operation that you list in the `/batch` request body, consider the required information and how unspecified fields will behave:

* **`deletes`**: only the `id` is required for each record object. You can keep additional parameters such as `name` for readability, but any other fields aside from `id` will be ignored in this case.
* **`patches`**: aside from each record `id`, you should specify the fields you want to update. All unspecified fields will remain as they are.
* **`puts`**: you must specify each record `id`, `content`, `name`, and `type`. You should also specify any other fields you want to set to a value that is not the default. Any unspecified fields will assume their default value for each [record type](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/). This operation works as an overwrite, so all fields in a given record are always affected.
* **`posts`**: since you are creating a new record, `id` is not required. For field definitions, refer to the [Create DNS Record](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/create/) endpoint and select the desired record type under the request body specification.

### Example request

In this example, the `proxied` field for the first record listed under `"puts"` will assume the default value (`false`).

```bash
{
    "deletes": [
        {
            "id": "2bff0ebc4df64beaa44b0dca93e37a28"
        },
        {
            "id": "31d1d6e79ce04b8d93cbc5a13401d728"
        }
    ],
    "patches": [
        {
            "id": "62276440f783445380480484648c1017",
            "content": "192.0.2.46"
        },
        {
            "id": "c942d948dc2343b9b97aed78479c9fb9",
            "name": "update.example.com",
            "proxied": true
        }
    ],
    "puts": [
        {
            "id": "a50364543094428abde0f14061d42b0e",
            "content": "192.0.2.50",
            "name": "change.example.com",
            "type": "A",
            "ttl:": 1
        },
        {
            "id": "3bce0920f19d43949498bd067b05dfa9",
            "content": "192.0.2.45",
            "name": "no-change.example.com",
            "type": "A",
            "proxied": false,
            "ttl:": 3000
        }
    ],
    "posts": [
        {
            "name": "@",
            "type": "A",
            "content": "192.0.2.41",
            "proxied": false,
            "ttl": 3000
        },
        {
            "name": "a.example.com",
            "type": "A",
            "content": "192.0.2.42",
            "proxied": true
        }
    ]
}
```
