---
title: Domain deleted from Cloudflare · Cloudflare DNS docs
description: "Domain deletion commonly occurs for the following reasons:"
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/zone-setups/troubleshooting/domain-deleted/
  md: https://developers.cloudflare.com/dns/zone-setups/troubleshooting/domain-deleted/index.md
---

Domain deletion commonly occurs for the following reasons:

* A user with access to the domain removed it.
* The nameservers no longer point to Cloudflare. Cloudflare continuously monitors domain registration.
* The domain was not authenticated (pending for 28 days).

***

## Check Audit Logs

Cloudflare [Audit Logs](https://developers.cloudflare.com/fundamentals/account/account-security/review-audit-logs/) contain information about domain deletion.

Note

*Delete* is an **Action** that denotes domain deletion but is also commonly used for deletion of other various account settings. Therefore, ensure that **Resource** says *Zone*.

***

## Check registrar for Cloudflare nameservers

If your domain was using a [full setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/), your registrar needs to use Cloudflare nameservers as the authoritative nameservers for your domain.

1. Use either the command-line based "whois" application provided with your Operating System or a website such as [ICANN Lookup](https://lookup.icann.org/).

   * If you are unable to find the nameserver details for your domain, reach out to your domain registrar or domain provider to provide the domain registration information.
   * Ensure Cloudflare’s nameservers are the only two nameservers listed in the domain registration details.
   * Ensure nameservers are spelled correctly in the domain registration.

2. Confirm that the nameservers exactly match the nameservers provided within the **Cloudflare Nameservers** card in **DNS** > **Records**.

3. If you identify incorrect information, log in to your domain provider’s portal to make updates or contact your domain provider for assistance.

***

## Recover a deleted domain

To recover a deleted domain, [re-add it in Cloudflare](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/) just like you would for a new domain.

Warning

Cloudflare support is unable to restore DNS or settings for deleted domains.
