---
title: Enable Email Routing · Cloudflare Email Routing docs
description: Email Routing is now enabled. You can add other custom addresses to
  your account.
lastUpdated: 2025-01-21T10:26:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-routing/get-started/enable-email-routing/
  md: https://developers.cloudflare.com/email-routing/get-started/enable-email-routing/index.md
---

Important

Enabling Email Routing adds the appropriate `MX` records to the DNS settings of your zone in order for the service to work. You can [change these `MX` records](https://developers.cloudflare.com/email-routing/setup/email-routing-dns-records/) at any time. However, depending on how you configure them, Email Routing might stop working.

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/) and select your account and domain.

2. Go to **Email** > **Email Routing**.

3. Review the records that will be added to your zone.

4. Select **Add records and enable**.

5. Go to **Routing rules**.

6. For **Custom addresses**, select **Create address**.

7. Enter the custom email address you want to use (for example, `my-new-email@example.com`).

8. In **Destination addresses**, enter the full email address you want your emails to be forwarded to — for example, `your-name@example.com`.

   Notes

   If you have several destination addresses linked to the same custom email address (rule), Email Routing will only process the most recent rule. To avoid this, do not link several destination addresses to the same custom address.

   The current implementation of email forwarding only supports a single destination address per custom address. To forward a custom address to multiple destinations you must create a Workers script to redirect the email to each destination. All the destinations used in the Workers script must be already validated.

9. Select **Save**.

10. Cloudflare will send a verification email to the address provided in the **Destination address** field. You must verify your email address before being able to proceed.

11. In the verification email Cloudflare sent you, select **Verify email address** > **Go to Email Routing** to activate Email Routing.

12. Your Destination address should now show **Verified**, under **Status**. Select **Continue**.

13. Cloudflare needs to add the relevant `MX` and `TXT` records to DNS records for Email Routing to work. This step is automatic and is only needed the first time you configure Email Routing. It is meant to ensure you have the proper records configured in your zone. Select **Add records and finish**.

Email Routing is now enabled. You can add other custom addresses to your account.

Note

When Email Routing is configured and running, no other email services can be active in the domain you are configuring. If there are other `MX` records already configured in DNS, Cloudflare will ask you if you wish to delete them. If you do not delete existing `MX` records, Email Routing will not be enabled.
