---
title: Domains · Cloudflare Email Security (formerly Area 1) docs
description: Email Security works through a system of domain-based routing,
  where Cloudflare receives and evaluates incoming email from a domain.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-security/email-configuration/domains-and-routing/domains/
  md: https://developers.cloudflare.com/email-security/email-configuration/domains-and-routing/domains/index.md
---

Email Security works through a system of domain-based routing, where Cloudflare receives and evaluates incoming email from a domain.

## Create a domain

To create a new domain in Email Security:

1. Log in to the [Email Security dashboard](https://horizon.area1security.com/).

2. Go to **Settings** (the gear icon).

3. Go to **Email Configuration** > **Domains & Routing** > **Domains**.

4. Select **New Domain**.

5. Enter the following information:

   * **Domain**: The domain name receiving email traffic.
   * **Configured As**: Choose **MX Records** or specify a number of **Hops** (depending on your email architecture).
   * **Forwarding To**: Enter the hostname of your email provider.
   * **IP Restrictions** (optional): Restrict incoming traffic to the IP addresses of your mail servers.
   * **Inbound TLS** (only available for non-MX domains): Applies TLS to incoming traffic.
   * **Outbound TLS**: Choose between **Forward all messages over TLS** (recommended) or **Forward all messages using opportunistic TLS**.
   * **Quarantine Policy**: Choose the [dispositions](https://developers.cloudflare.com/email-security/reference/dispositions-and-attributes/) you want to send to [Admin quarantine](https://developers.cloudflare.com/email-security/email-configuration/admin-quarantine/).

6. Select **Publish Domain**.

***

## Edit a domain

To edit an existing domain:

1. Log in to the [Email Security dashboard](https://horizon.area1security.com/).
2. Go to **Settings** (the gear icon).
3. Go to **Email Configuration** > **Domains & Routing** > **Domains**.
4. On a specific domain, select **...** > **Edit**.
5. Make changes as needed.
6. Select **Update Domain**.

***

## Delete a domain

To delete a domain:

1. Log in to the [Email Security dashboard](https://horizon.area1security.com/).
2. Go to **Settings** (the gear icon).
3. Go to **Email Configuration** > **Domains & Routing** > **Domains**.
4. On a specific domain, select **...** > **Delete**.
