---
title: Firewall rules actions · Cloudflare Firewall Rules (deprecated) docs
description: The action of a firewall rule tells Cloudflare how to handle HTTP
  requests that have matched the rule expression.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/firewall/cf-firewall-rules/actions/
  md: https://developers.cloudflare.com/firewall/cf-firewall-rules/actions/index.md
---

The action of a firewall rule tells Cloudflare how to handle HTTP requests that have matched the rule expression.

Deprecation notice

Cloudflare Firewall Rules has been deprecated. Cloudflare has moved existing firewall rules to [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/). For more information on this change, refer to the [upgrade guide](https://developers.cloudflare.com/waf/reference/legacy/firewall-rules-upgrade/).

## Supported actions

The table below lists the actions available in firewall rules. These actions are listed in order of precedence. If the same request matches two different rules which have the same priority, precedence determines the action to take.

For example, the *Allow* action takes precedence over the *Block* action. In a case where a request matches a rule with the *Allow* action and another with the *Block* action, precedence resolves the tie, and Cloudflare allows the request.

There are two exceptions to this behavior: the *Log* and *Bypass* actions. Unlike other actions, *Log* and *Bypass* do not terminate further evaluation within firewall rules. This means that if a request matches two different rules and one of those rules specifies the *Log* or *Bypass* action, the second action will be triggered instead, even though *Log*/*Bypass* has precedence.

Note

For reference information on rule actions available for Cloudflare products powered by the Ruleset Engine, refer to [Rules language: Actions](https://developers.cloudflare.com/ruleset-engine/rules-language/actions/).

| Action | Description | Order of precedence |
| - | - | - |
| **Log** API value: `log` | * Records matching requests in the Cloudflare Logs.

* Only available for Enterprise plans.

* Recommended for validating rules before committing to a more severe action. | 1 |
| **Bypass** API value: `bypass` | - Allows user to dynamically disable Cloudflare security features for a request.

- Available to all plans.

- Matching requests exempt from evaluation by a user-defined list containing one or more of the following Cloudflare security features:

  * [User Agent Blocking](https://developers.cloudflare.com/waf/tools/user-agent-blocking/)

  * [Browser Integrity Check](https://developers.cloudflare.com/waf/tools/browser-integrity-check/)

  * [Hotlink Protection](https://developers.cloudflare.com/waf/tools/scrape-shield/hotlink-protection/)

  * [Security Level (IP Reputation)](https://developers.cloudflare.com/waf/tools/security-level/)

  * [Rate Limiting](https://developers.cloudflare.com/waf/reference/legacy/old-rate-limiting/) (previous version, deprecated)

  * [Zone Lockdown](https://developers.cloudflare.com/waf/tools/zone-lockdown/)

  * [WAF managed rules](https://developers.cloudflare.com/waf/reference/legacy/old-waf-managed-rules/) (previous version, deprecated)

  **Notes:**

  * Currently, you cannot bypass Bot Fight Mode. For more information on this product, refer to [Cloudflare bot solutions](https://developers.cloudflare.com/bots/).

  * You cannot bypass the new [WAF managed rules](https://developers.cloudflare.com/waf/managed-rules/) using this action, only the previous version of WAF managed rules. To skip one or more managed rules in the new WAF for specific requests, [create an exception](https://developers.cloudflare.com/waf/managed-rules/waf-exceptions/).

- Requests which match the *Bypass* action are still subject to evaluation (and thus a challenge or block) within Firewall Rules, based on the order of execution. | 2 |
| **Allow** API value: `allow` | * Matching requests are exempt from *Bypass*, *Block*, and challenge actions triggered by other firewall rules.

* The scope of the *Allow* action is limited to firewall rules; matching requests are **not** exempt from action by other Cloudflare security products such as Bot Fight Mode, IP Access Rules, and WAF Managed Rules.

* Matched requests will be mitigated if they are part of a DDoS attack. | 3 |
| **Interactive Challenge** API value: `challenge` | - This option is not recommended. Instead, choose **Managed Challenge (Recommended)**, which issues interactive challenges to visitors only when necessary.

- The client that made the request must pass an interactive challenge.

- If successful, Cloudflare accepts the matched request; otherwise, it is blocked.

- For additional information, refer to [Notes about challenge actions](#notes-about-challenge-actions). | 4 |
| **Managed Challenge (Recommended)** API value: `managed_challenge` | * Helps reduce the lifetimes of human time spent solving interactive challenges across the Internet.

* Depending on the characteristics of a request, Cloudflare will dynamically choose the appropriate type of challenge from the following actions based on specific criteria:

  * Show a non-interactive challenge page (similar to the current JS Challenge).

  * Show an interactive challenge (such as requiring the visitor to click a button or to perform a task).

* For additional information, refer to [Notes about challenge actions](#notes-about-challenge-actions). | 5 |
| **JS Challenge** API value: `js_challenge` | - Useful for ensuring that bots and spam cannot access the requested resource; browsers, however, are free to satisfy the challenge automatically.

- The client that made the request must pass a Cloudflare JavaScript Challenge before proceeding.

- If successful, Cloudflare accepts the matched request; otherwise, it is blocked.

- For additional information, refer to [Notes about challenge actions](#notes-about-challenge-actions). | 6 |
| **Block** API value: `block` | Matching requests are denied access to the site. | 7 |

## Notes about challenge actions

When you configure a firewall rule with one of the challenge actions — *Managed Challenge*, *JS Challenge*, or *Interactive Challenge* — and a request matches the rule, one of two things can happen:

* The request is blocked if the visitor fails the challenge
* The request is allowed if the visitor passes the challenge

In this last case, no further firewall rules will be processed. This means that the action of any later rules with a challenge or *Block* action also matching the request will not be applied, and the request will be allowed.
