---
title: Create an Access application · Cloudflare Learning Paths
description: Cloudflare Access allows you to securely publish internal tools and
  applications to the Internet by providing an authentication layer between the
  end user and your origin server. You can use signals from your existing
  identity providers (IdPs), device posture providers, and other rules to
  control who can access your application.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/clientless-access/access-application/create-access-app/
  md: https://developers.cloudflare.com/learning-paths/clientless-access/access-application/create-access-app/index.md
---

Cloudflare Access allows you to securely publish internal tools and applications to the Internet by providing an authentication layer between the end user and your origin server. You can use signals from your existing identity providers (IdPs), device posture providers, and [other rules](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/#selectors) to control who can access your application.

Each application can have multiple policies with different constraints depending on what user group is accessing the application. For example, you can create one policy that requires corporate users to present specific device posture checks or mutual TLS authentication events, and a second policy for contractors which does not require these attributes.

## Add your application to Access

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Select **Add an application**.

3. Select **Self-hosted**.

4. Enter any name for the application.

5. In **Session Duration**, choose how often the user's [application token](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/application-token/) should expire.

   Cloudflare checks every HTTP request to your application for a valid application token. If the user's application token (and global token) has expired, they will be prompted to reauthenticate with the IdP. For more information, refer to [Session management](https://developers.cloudflare.com/cloudflare-one/identity/users/session-management/).

1) Select **Add public hostname**.

2) In the **Domain** dropdown, select the domain that will represent the application. Domains must belong to an active zone in your Cloudflare account. You can use [wildcards](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/app-paths/) to protect multiple parts of an application that share a root path.

   Alternatively, to use a [Cloudflare for SaaS custom hostname](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/secure-with-access/), set **Input method** to *Custom* and enter your custom hostname.

3) (Optional) Configure **Browser rendering settings**:

   * [Automatic `cloudflared` authentication](https://developers.cloudflare.com/cloudflare-one/applications/non-http/cloudflared-authentication/automatic-cloudflared-authentication/)
   * [Browser rendering for SSH, VNC, or RDP](https://developers.cloudflare.com/cloudflare-one/applications/non-http/browser-rendering/)

4) Add [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) to control who can connect to your application. All Access applications are deny by default -- a user must match an Allow policy before they are granted access.

5) Configure how users will authenticate:

   1. Select the [**Identity providers**](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/) you want to enable for your application.

   2. (Recommended) If you plan to only allow access via a single IdP, turn on **Instant Auth**. End users will not be shown the [Cloudflare Access login page](https://developers.cloudflare.com/cloudflare-one/applications/login-page/). Instead, Cloudflare will redirect users directly to your SSO login event.

   3. (Optional) Under **WARP authentication identity**, allow users to authenticate to the application using their [WARP session identity](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/).

6) Select **Next**.

7) (Optional) Configure [App Launcher settings](https://developers.cloudflare.com/cloudflare-one/applications/app-launcher/) for the application.

8) Under **Block page**, choose what end users will see when they are denied access to the application:

   * **Cloudflare default**: Reload the [login page](https://developers.cloudflare.com/cloudflare-one/applications/login-page/) and display a block message below the Cloudflare Access logo. The default message is `That account does not have access`, or you can enter a custom message.
   * **Redirect URL**: Redirect to the specified website.
   * **Custom page template**: Display a [custom block page](https://developers.cloudflare.com/cloudflare-one/applications/block-page/) hosted in Zero Trust.

9) Select **Next**.

10) (Optional) Configure advanced settings:

    * [**Cross-Origin Resource Sharing (CORS) settings**](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/cors/)
    * [**Cookie settings**](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/#cookie-settings)
    * **401 Response for Service Auth policies**: Return a `401` response code when a user (or machine) makes a request to the application without the correct [service token](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/).

11) Select **Save**.

When users go to the application, they will be prompted to login with your identity provider.
