---
title: What security features does Cloudflare provide? · Cloudflare Learning Paths
description: Review concepts related to Cloudflare Internet traffic and SaaS app security.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/concepts/security-concepts/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/concepts/security-concepts/index.md
---

Review concepts related to Cloudflare Internet traffic and SaaS app security.

## What is 1.1.1.1?

1.1.1.1 is Cloudflare's free, fast, and secure public DNS resolver.

For more information, refer to the [Learning Center](https://www.cloudflare.com/learning/dns/what-is-1.1.1.1/) and [1.1.1.1 documentation](https://developers.cloudflare.com/1.1.1.1/).

## What is a secure web gateway (SWG)?

A secure web gateway (SWG) is a cyber security product that protects company data and enforces security policies.

Cloudflare Gateway is a modern next-generation firewall between your user, device, or network and the public Internet. It includes DNS filtering to inspect and apply policies to all Internet-bound DNS queries.

For more information, refer to the [Learning Center](https://www.cloudflare.com/learning/access-management/what-is-a-secure-web-gateway/) and [Gateway documentation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/).

## What is HTTPS inspection?

HTTPS inspection (also known as TLS decryption) is the process of filtering traffic by decrypting traffic sent to or from your organization, inspecting it and applying policies, then re-encrypting the traffic as it ingresses or egresses.

For more information, refer to the [Learning Center](https://www.cloudflare.com/learning/security/what-is-https-inspection/) and [TLS decryption documentation](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/).

## What is data loss prevention (DLP)?

Data loss prevention checks for sensitive data sent in uploads and downloads.

Cloudflare [Data Loss Prevention](https://www.cloudflare.com/learning/access-management/what-is-dlp/) (DLP) allows you to scan your web traffic and SaaS applications for the presence of sensitive data such as social security numbers, financial information, secret keys, and source code.

For more information, refer to the [Learning Center](https://www.cloudflare.com/learning/access-management/what-is-dlp/) and [DLP documentation](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/).

## What is a cloud access security broker (CASB)?

A cloud access security broker protects cloud services from security threats.

Cloudflare CASB provides comprehensive visibility and control over SaaS apps to prevent data leaks and compliance violations. It helps detect insider threats, shadow IT, risky data sharing, and bad actors.

For more information, refer to the [Learning Center](https://www.cloudflare.com/learning/access-management/what-is-a-casb/) and [CASB documentation](https://developers.cloudflare.com/cloudflare-one/applications/casb/).

## What is browser isolation?

Browser isolation prevents users from interacting directly with malicious websites by rendering pages in an isolated browser offsite.

Cloudflare Browser Isolation seamlessly executes active webpage content in a secure isolated browser to protect users from zero-day attacks, malware, and phishing.

For more information, refer to the [Learning Center](https://www.cloudflare.com/learning/access-management/what-is-a-casb/) and [Browser Isolation documentation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/).
