---
title: Overview · Cloudflare Network Interconnect docs
description: Cloudflare Network Interconnect (CNI) allows you to connect your
  network infrastructure directly to Cloudflare — rather than using the public
  Internet — for a more reliable and secure experience. With CNI, you can bring
  Cloudflare's full suite of network functions to your physical network edge.
lastUpdated: 2025-09-02T14:32:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/network-interconnect/
  md: https://developers.cloudflare.com/network-interconnect/index.md
---

Connect your network infrastructure directly to Cloudflare

Enterprise-only

Cloudflare Network Interconnect (CNI) allows you to connect your network infrastructure directly to Cloudflare — rather than using the public Internet — for a more reliable and secure experience. With CNI, you can bring Cloudflare's full suite of network functions to your physical network edge.

## Why Use CNI? Key Benefits

Enterprises use CNI to achieve:

* **Enhanced Performance**: Gain lower latency and more consistent network throughput.
* **Increased Security**: Reduce your network's attack surface by connecting privately and avoiding the public Internet.

## Connection Types

Choose the model that best fits your infrastructure and operational needs.

| | Direct Interconnect | Partner Interconnect |
| - | - | - |
| **Port type** | A dedicated physical fiber connection between your network equipment and Cloudflare's hardware in a shared data center. | A virtual connection to Cloudflare established through one of our global connectivity partners. |
| **Operations** | You are responsible for procuring and managing the physical cross-connect to Cloudflare's equipment. | Your partner manages the connection logistics, often through a software-defined networking portal. |
| **Ideal use case** | For customers collocated with Cloudflare who require maximum control, performance, and reliability. | For customers who are not in the same data center as Cloudflare or prefer a managed connectivity solution. |

## Dataplane

Cloudflare's data centers may support one or more interconnect dataplanes. The dataplane is the type of equipment that terminates your direct connection:

* **Dataplane v1.0**: A peering connection to a Cloudflare edge data center that supports GRE tunnels for connecting with the Magic Networking overlay.
* **Dataplane v1.1**: An enhanced version of the 1.0 dataplane that supports GRE-less delivery for Magic Transit Direct Server Return.

When you review the [available locations](https://developers.cloudflare.com/network-interconnect/static/cni-locations-04-08-2025.pdf) (PDF), you can see which dataplane version(s) are available.

## Product Use Cases

CNI provides a private point-to-point IP connection with Cloudflare. There are two dataplanes that come with different technical specifications.

| | Dataplane v1.0 | Dataplane v1.1 |
| - | - | - |
| **Magic Transit Direct Server Return (DSR)** DDoS protection for all ingress traffic from the Internet to your public network. Send egress traffic via your ISP. | Supported with a GRE tunnel established over the interconnect circuit. | Supported with or without a GRE tunnel established over the interconnect circuit. |
| **Magic Transit with Egress** DDoS protection for all ingress traffic from the Internet to your public network. Send egress traffic via Cloudflare. | Supported with a GRE tunnel established over the interconnect circuit. | Supported with a GRE tunnel established over the interconnect circuit. |
| **Magic WAN and Zero Trust** Build a secure, private network backbone connecting your Zero Trust users and applications with all your sites, data centers, and clouds. | Supported with a GRE tunnel established over the interconnect circuit. | Supported with or without a GRE tunnel established over the interconnect circuit. |
| **Peering** Exchange public routes with a single Cloudflare PoP (Point of Presence). | Supported. All customers connecting with the edge data center will exchange public routes at that PoP with AS13335. Connectivity is established at each individual PoP. Routes for other edge locations in Cloudflare's network may not be available. Routes for customer-advertised prefixes will be available only in the connected PoP. | Supported. All customers connecting with the edge data center will exchange public routes at that PoP with AS13335. Connectivity is established at each individual PoP. Routes for other edge locations in Cloudflare's network may not be available. Routes for customer-advertised prefixes will be available only in the connected PoP. |
| **Application Security and Performance** Improve the performance and security of your web applications | **Supported via peering**: Customers can use Argo Smart Routing to direct origin traffic via the edge peering connection when it is determined to be the lowest latency option. Customers must maintain a direct Internet connection which will always be used for a portion of traffic and during failure scenarios. **Supported Via Magic Transit**: Customers may configure any product with an origin server IP address that is protected by Magic Transit. Magic Transit will direct this traffic via the overlay and customer can control interconnect next-hops using the Magic networking routing table. | **Supported via peering**: Customers can use Argo Smart Routing to direct origin traffic via the edge peering connection when it is determined to be the lowest latency option. Customers must maintain a direct Internet connection which will always be used for a portion of traffic and during failure scenarios. **Supported Via Magic Transit**: Customers may configure any product with an origin server IP address that is protected by Magic Transit. Magic Transit will direct this traffic via the overlay and customer can control interconnect next-hops using the Magic networking routing table. |

For more details refer to the [prerequisites section](https://developers.cloudflare.com/network-interconnect/get-started/#prerequisites).

### Designing for high availability

To protect against a single point of failure, it is critical to design your CNI deployment for resilience. For business-critical applications, seek Cloudflare locations that support diversity on the device level, which ensures your connections terminate on physically separate hardware.

Refer to [Service Expectations](https://developers.cloudflare.com/network-interconnect/get-started/#service-expectations) for more information.

***

## Related products

**[Magic Transit](https://developers.cloudflare.com/magic-transit/)**

Magic Transit is a network security and performance solution that offers DDoS protection, traffic acceleration, and more for on-premise, cloud-hosted, and hybrid networks.

**[Magic WAN](https://developers.cloudflare.com/magic-wan/)**

Improve security and performance for your entire corporate network, reducing cost and operation complexity.
