---
title: How to use · Cloudflare Reference Architecture docs
description: Below are the different types of architecture content and
  information is organized from high level reference architectures, to design
  guides with best practices and guidelines to implementation guides which
  provide detailed steps to deploy a specific solution.
lastUpdated: 2024-09-27T15:14:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/reference-architecture/how-to-use/
  md: https://developers.cloudflare.com/reference-architecture/how-to-use/index.md
---

The reference architecture content in our documentation is designed to help you understand how Cloudflare has been designed and built, and how our products and services integrate with your current IT architecture.

Below are the different types of architecture content and information is organized from high level reference architectures, to design guides with best practices and guidelines to implementation guides which provide detailed steps to deploy a specific solution.

## Reference architectures

[Reference architectures](https://developers.cloudflare.com/reference-architecture/architectures/) provide a foundational knowledge of the Cloudflare platform and products while offering a description for how they relate to your existing infrastructure and business challenges. They are high-level, conceptual documents that walk through the concepts of an area of our platform, mapping our network, products and features to the typical architecture of a customer's environment. Detailed diagrams with supporting content explain how our technology works and how it can be integrated with your own infrastructure. The goal of a reference architecture is:

* Present thought leadership for a broad technology area
* Visualize the architecture of Cloudflare and understand how it's been designed
* Explain integration points between Cloudflare and your infrastructure

## Reference architecture diagrams

A [reference architecture diagram](https://developers.cloudflare.com/reference-architecture/diagrams/) focusses on a specific solution or use case where Cloudflare can be used. One or more diagrams are the primary content with supporting introduction and summary. These can focus on sections from a reference architecture that are not fully developed. The goal of this type of document is:

* Visualize the components of a specific solution's architecture
* Provide a quick answer to a specific question around a use case

## Design guides

These [guides](https://developers.cloudflare.com/reference-architecture/design-guides/) are typically aimed at architects, developers, and IT professionals who are tasked with designing and deploying systems that leverage the company's technologies. They typically focus on a specific solution that would be a subset of the greater architecture. For example, if you have read our [SASE Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/sase/), but are a startup, you may want to understand the details of using a [SASE approach for a small startup](https://developers.cloudflare.com/reference-architecture/design-guides/zero-trust-for-startups/). These documents are:

* Helping you think through how to design a deployment of Cloudflare as part of an overall solution.
* More prescriptive than reference architectures, sharing best practices and guidelines.
* Focused on a solution design that you are trying to achieve, such as connecting private networks to Cloudflare, or using a web application firewall to secure a public website.
* Not a replacement for product documentation and do not describe specific product configuration or commands to run.

## Implementation guides

Implementation guides provide [step-by-step instructions](https://developers.cloudflare.com/reference-architecture/implementation-guides/) and practical guidance for how to effectively deploy and configure specific solutions or services. Implementation guides are focused on a specific implementation goal. While a design guide provides the overall best practices for designing a solution, an implementation guide details the actual steps to deploy in the context of a specific job-to-be-done. These documents are:

* Focused on a specific implementation outcome, such as connecting a remote office using the Magic WAN Connector.
* Provide information about the exact commands and configuration steps to take.
