---
title: Actions reference · Cloudflare Ruleset Engine docs
description: Learn about actions supported by the Rules language, including
  Block, Skip, and Log.
lastUpdated: 2025-10-22T08:15:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/actions/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/actions/index.md
---

The action of a rule tells Cloudflare how to handle matches for the rule [expression](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/).

## Supported actions

The table below lists the actions available in the Rules language.

Some actions like *Block*, called terminating actions, will stop the evaluation of the remaining rules. The *Skip* action will skip the evaluation of *some* rules when there is a match, but the exact behavior will depend on the rule configuration.

The available actions depend on the [phase](https://developers.cloudflare.com/ruleset-engine/about/phases/) where you are configuring the rule. Refer to each product’s documentation for details on the phase(s) supported by that product.

| Action | Description | Terminating action? |
| - | - | - |
| **Interactive Challenge** API value: `challenge` | Useful for ensuring that the visitor accessing the site is human, not automated.The client that made the request must pass an interactive challenge.If successful, Cloudflare accepts the matched request; otherwise, it is blocked. | Yes |
| **JS Challenge** API value: `js_challenge` | Useful for ensuring that bots and spam cannot access the requested resource; browsers, however, are free to satisfy the challenge automatically.The client that made the request must pass a Cloudflare JavaScript Challenge before proceeding.If successful, Cloudflare accepts the matched request; otherwise, it is blocked. | Yes |
| **Managed Challenge (Recommended)** API value: `managed_challenge` | Helps reduce the lifetimes of human time spent solving CAPTCHAs across the Internet.Depending on the characteristics of a request, Cloudflare will dynamically choose the appropriate type of challenge from the following actions based on specific criteria:- Show a non-interactive challenge page (similar to the current JS Challenge).
- Show a custom interactive challenge (such as click a button). | Yes |
| **Block** API value: `block` | Matching requests are denied access to the site.Depending on the Cloudflare product performing the block action, the HTTP status code can be [`403`](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-403/#cloudflare-specific-information) (most security features) or [`429`](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/4xx-client-error/error-429/#website-end-users) (for example, rate limiting rules).Customers on paid plans can customize the HTML error page displayed to website visitors due to the block action. Refer to [Error Pages](https://developers.cloudflare.com/rules/custom-errors/#error-pages) for more information.Customers in Pro plans and above can customize the response (HTML, JSON, XML, or plain text) and the response status code for each [custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/#configure-a-custom-response-for-blocked-requests) or [rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/create-zone-dashboard/#configure-a-custom-response-for-blocked-requests) that triggers a block action. | Yes |
| **Skip** API value: `skip` | Allows user to dynamically skip one or more security features or products for a request.Depending on the rule configuration, matching requests will skip the evaluation of one or more security features or products:- Skip all remaining rules in the current ruleset
- Skip rulesets
- Skip rules of a ruleset
- Skip phases
- Skip specific security products that are not based on the Ruleset EngineThe available skip options depend on the phase where you configure the rule. Refer to each product’s documentation for details.If you configure a rule with the *Skip* action at the account level it will only affect rules/phases configured at the account level, not at the zone level. To skip rules/phases at the zone level you must configure a rule with the *Skip* action at the zone level. | No (but some rules may be skipped) |
| **Log** API value: `log` | Records matching requests in the Cloudflare Logs.Only available on Enterprise plans.Recommended for validating rules before committing to a more severe action. | No |
| **Execute** API value: `execute` | Executes the rules in the ruleset specified in the rule configuration. You can specify a managed ruleset or a custom ruleset to execute.In the Cloudflare dashboard, this action is not listed in action selection dropdowns. | No |
| **Rewrite** API value: `rewrite` | Rewrites the request (or response) by adjusting the URI path, query string, and/or HTTP request/response headers, according to the rule configuration.Only available in:- [Transform Rules](https://developers.cloudflare.com/rules/transform/), in phases `http_request_transform`, `http_request_late_transform`, and `http_response_headers_transform`. In the Cloudflare dashboard, this action is not listed in action selection dropdowns. To use this action, create a Transform Rule.
- WAF custom rules checking for [exposed credentials](https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/), in the `http_request_firewall_custom` phase at the account level. In the Cloudflare dashboard, this action is called *Exposed-Credential-Check Header*. | No |
| **Redirect** API value: `redirect` | Navigates the user from a source URL to a target URL, according to the rule configuration, by replying with an HTTP redirect.Only available for [Single Redirects](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/) and [Bulk Redirects](https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/).In the Cloudflare dashboard, this action is not listed in action selection dropdowns. To use this action, create a redirect rule or a bulk redirect rule. | Yes |
| **Route** API value: `route` | Adjusts the `Host` header, Server Name Indication (SNI), resolved hostname, and/or resolved destination port of incoming requests.Only available for [Origin Rules](https://developers.cloudflare.com/rules/origin-rules/), in the `http_request_origin` phase.In the Cloudflare dashboard, this action is not listed in action selection dropdowns. To use this action, create an origin rule. | No |
| **Set Configuration** API value: `set_config` | Changes the configuration settings of one or more Cloudflare products.Only available for [Configuration Rules](https://developers.cloudflare.com/rules/configuration-rules/), in the `http_config_settings` phase.In the Cloudflare dashboard, this action is not listed in action selection dropdowns. To use this action, [create a Configuration Rule](https://developers.cloudflare.com/rules/configuration-rules/create-dashboard/). | No |
| **Compress Response** API value: `compress_response` | Defines compression settings for delivering responses to website visitors.Only available for [Compression Rules](https://developers.cloudflare.com/rules/compression-rules/), in the `http_response_compression` phase.In the Cloudflare dashboard, this action is not listed in action selection dropdowns. To use this action, [create a compression rule](https://developers.cloudflare.com/rules/compression-rules/create-dashboard/). | No |
| **Set Cache Settings** API value: `set_cache_settings` | Cache Rules allows you to customize cache settings on Cloudflare.Only available for [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/), in the `http_request_cache_settings` phase.In the Cloudflare dashboard, this action is not listed in action selection dropdowns. To use this action, [create a cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/create-dashboard/). | No |
| **Serve Error** API value: `serve_error` | Serves error content to the website visitor, according to the custom error rule configuration.Only available for [Custom Error Rules](https://developers.cloudflare.com/rules/custom-errors/#custom-error-rules), in the `http_custom_errors` phase.In the Cloudflare dashboard, this action is not listed in action selection dropdowns. To use this action, [create a custom error rule](https://developers.cloudflare.com/rules/custom-errors/create-rules/#create-a-custom-error-rule-dashboard). | Yes |
| **Log custom field** API value: `log_custom_field` | Configures custom fields for Logpush jobs in a zone.Only available for [custom fields](https://developers.cloudflare.com/logs/logpush/logpush-job/custom-fields/), in the `http_log_custom_fields` phase.In the Cloudflare dashboard, this action is not listed in action selection dropdowns. To use this action, [configure custom log fields](https://developers.cloudflare.com/logs/logpush/logpush-job/custom-fields/#enable-custom-fields-via-dashboard) for Logpush jobs. | Yes |

Note

Cloudflare Firewall Rules, now deprecated, supports a different set of actions, including the *Allow* and *Bypass* actions. Refer to [Firewall rules actions](https://developers.cloudflare.com/firewall/cf-firewall-rules/actions/) for more information.
