---
title: Cloudflare Mirage (deprecated) · Cloudflare Speed docs
description: Cloudflare Mirage reduces bandwidth used by images in mobile
  browsers. It can accelerate loading of image-heavy websites on very slow
  mobile connections and HTTP/1.
lastUpdated: 2025-10-10T13:43:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/speed/optimization/images/mirage/
  md: https://developers.cloudflare.com/speed/optimization/images/mirage/index.md
---

Deprecation notice

Mirage was deprecated on September 15, 2025. As an alternative, Cloudflare recommends using [lazy loading](https://developers.cloudflare.com/images/tutorials/optimize-mobile-viewing/) and [responsive images](https://developers.cloudflare.com/images/transform-images/make-responsive-images/) to optimize image performance for all devices.

Cloudflare Mirage reduces bandwidth used by images in mobile browsers. It can accelerate loading of image-heavy websites on very slow mobile connections and HTTP/1.

It does this by:

* Replacing images with low-resolution thumbnails, which are bundled together into one file.
* Acting as a lazy loader, deferring loading of higher-resolution images until they become visible.

JavaScript must be enabled for Mirage to work.

***

## Comparison

* [Polish](https://developers.cloudflare.com/images/polish/) seamlessly optimizes images for all browsers, not only mobile, and keeps images at full resolution.
* [Image Resizing](https://developers.cloudflare.com/images/transform-images/) together with `loading="lazy"` and `srcset` HTML attributes can achieve similar results as Mirage, but requires markup changes to implement.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | No | Yes | Yes | Yes |

***

## Image formats compatible with Mirage

Mirage will work with the following image formats:

* `.jpg`
* `.jpeg`
* `.png`
* `.gif`
* `.img`

***

## Enable Mirage

Note

If you send a Content Security Policy (CSP) header that restricts where scripts can be loaded, you will need to ensure `ajax.cloudflare.com` is enabled. For example, to allow scripts from your own domain and `ajax.cloudflare.com` enter the following: `script-src 'self' ajax.cloudflare.com;`

To enable Mirage image optimization for your entire domain:

1. In the Cloudflare dashboard, go to the **Speed** > **Settings** page.

   [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/speed/optimization)

2. Go to **Image Optimization**.

3. For **Mirage**, switch the toggle to **On**.

Note

To use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/).

***

## Test Mirage

Mirage's features for Mobile Browser optimization are triggered based on high latency and poor network connections. You can test Mirage by making a request to your domain using a mobile [user-agent string](http://en.wikipedia.org/wiki/User_agent) and one of the following flags with your domain in your mobile browser:

`EXAMPLE.COM/?forcepreload`

To run the pre-loader only and serve degraded images on the page enter:

`EXAMPLE.COM/?forcepreloadonly`

Here is an example where Mirage 2 is triggered by a `?forcepreloadonly` flag. The notable image degradation is a sign that Mirage is working:

![Blog post regarding the launch of Mirage.
](https://developers.cloudflare.com/_astro/hc-import-219178057_forcepreloadonly.Cs6EzIwK_Z1RXDSB.webp)
