---
title: Overview · Cloudflare SSL/TLS docs
description: Cloudflare SSL/TLS offers free Universal SSL alongside advanced and
  enterprise features to meet your encryption and certificate management needs.
lastUpdated: 2025-01-15T09:15:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/
  md: https://developers.cloudflare.com/ssl/index.md
---

Encrypt your web traffic to prevent data theft and other tampering.

Available on all plans

Through [Universal SSL](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/), Cloudflare is the first Internet performance and security company to offer free SSL/TLS protection. Cloudflare SSL/TLS also provides a number of other features to meet your encryption requirements and certificate management needs. Refer to [Get started](https://developers.cloudflare.com/ssl/get-started/) for more.

***

## Features

### Total TLS

Extending the protection offered by Universal SSL, Total TLS is an easy way to automatically issue certificates for all levels of subdomains that you have.

[Use Total TLS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/)

### Delegated DCV

Even if you use a different provider for authoritative DNS, you can delegate domain control validation (DCV) to Cloudflare, reducing the need of manual intervention.

[Use Delegated DCV](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/delegated-dcv/)

### Custom TLS settings

Cloudflare also allows you to specify the minimum TLS version that visitors must use to connect to your website or application, and [restrict cipher suites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/customize-cipher-suites/) according to your security requirements.

[Use Custom TLS settings](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/minimum-tls/)



Refer to [features and availability](https://developers.cloudflare.com/ssl/reference/all-features/) for a complete list of SSL/TLS features and their availability according to different Cloudflare plans.

***

## Related products

**[Cloudflare DNS](https://developers.cloudflare.com/dns/)**

When you use Cloudflare DNS, all DNS queries for your domain are answered by Cloudflare's global anycast network. This network delivers performance and global availability.

**[Cloudflare for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/)**

Cloudflare for SaaS allows you to extend the security and performance benefits of Cloudflare's network to your customers via their own custom or vanity domains.
