---
title: Certificate authorities · Cloudflare SSL/TLS docs
description: For publicly trusted certificates, Cloudflare partners with
  different certificate authorities (CAs). Refer to this page to check what CAs
  are used for each Cloudflare offering and for more details about the CAs
  features, limitations, and browser compatibility.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/reference/certificate-authorities/
  md: https://developers.cloudflare.com/ssl/reference/certificate-authorities/index.md
---

For publicly trusted certificates, Cloudflare partners with different certificate authorities (CAs). Refer to this page to check what CAs are used for each Cloudflare offering and for more details about the CAs [features, limitations, and browser compatibility](#features-limitations-and-browser-compatibility).

## Availability per certificate type and encryption algorithm

| Certificate | Algorithm | [Let's Encrypt](#lets-encrypt) | [Google Trust Services](#google-trust-services) | [SSL.com](#sslcom) | [Sectigo](#sectigo) |
| - | - | - | - | - | - |
| [Universal](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/) | ECDSA  RSA (Paid plans only) | ✅  ✅ | ✅  ✅ | ✅  ✅ | N/A  N/A |
| [Advanced](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) | ECDSA  RSA | ✅  ✅ | ✅  ✅ | ✅  ✅  | N/A  N/A |
| [Total TLS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/) | ECDSA  RSA | ✅  ✅ | ✅  ✅ | ✅  ✅  | N/A  N/A |
| [SSL for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/issue-and-validate/) | ECDSA  RSA | ✅  ✅ | ✅  ✅ | ✅  ✅  | N/A  N/A |
| [Backup](https://developers.cloudflare.com/ssl/edge-certificates/backup-certificates/) | ECDSA RSA | ✅ ✅ | ✅ ✅ | ✅ ✅ | ✅ ✅ |

## Features, limitations, and browser compatibility

Universal SSL

For Universal certificates, Cloudflare controls the validity periods and certificate authorities (CAs), making sure that renewal always occur. For details, refer to [Universal SSL](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/).

***

### Let's Encrypt

* Supports [validity periods](https://developers.cloudflare.com/ssl/reference/certificate-validity-periods/) of 90 days.
* [DCV tokens](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/) are valid for 7 days.

#### Limitations

* Hostname on certificate can contain up to 10 levels of subdomains.
* Duplicate certificate limit of [5 certificates](https://letsencrypt.org/docs/rate-limits/) per week.

#### Browser compatibility

Warning

This section summarizes commonly requested client support information. For the complete and most up-to-date certificate compatibility, refer to [Let's Encrypt documentation](https://letsencrypt.org/docs/certificate-compatibility/).

The main determining factor for whether a platform can validate Let's Encrypt certificates is whether that platform trusts the self-signed ISRG Root X1 certificate. As Let's Encrypt announced a [change in its chain of trust in 2024](https://blog.cloudflare.com/shortening-lets-encrypt-change-of-trust-no-impact-to-cloudflare-customers/), older devices (for example Android 7.0 and earlier) that only trust the cross-signed version of the ISRG Root X1 are no longer compatible.

You can find the full list of supported clients in the [Let's Encrypt documentation](https://letsencrypt.org/docs/certificate-compatibility/). Older versions of Android and Java clients might not be compatible with Let's Encrypt certificates.

#### Other resources

[Let's Encrypt Root CAs](https://letsencrypt.org/certificates/): For checking compatibility between chain and client. As explained in [Certificate pinning](https://developers.cloudflare.com/ssl/reference/certificate-pinning/), you should **not** use this list for pinning against.

***

### Google Trust Services

* Supports [validity periods](https://developers.cloudflare.com/ssl/reference/certificate-validity-periods/) of 14, 30, and 90 days.
* [DCV tokens](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/) are valid for 14 days.

#### Limitations

* Punycode domains are not yet supported.

#### Browser compatibility (most compatible)

Warning

This section summarizes commonly requested client support information. For the complete and most up-to-date certificate compatibility, refer to [Google Trust Services documentation](https://pki.goog/faq/).

By cross-signing with a [GlobalSign root CA](https://valid.r1.roots.globalsign.com/) that has been installed in client devices for more than 20 years, Google Trust Services can ensure optimal support across a wide range of devices.

Currently trusted by Microsoft, Mozilla, Safari, Cisco, Oracle Java, and Qihoo’s 360 browser, all browsers or operating systems that depend on these root programs are covered.

You can use the [root CAs list](https://pki.goog/faq/#faq-27) for checking compatibility between chain and client but, as explained in [Certificate pinning](https://developers.cloudflare.com/ssl/reference/certificate-pinning/), you should **not** use this list for pinning against.

***

### SSL.com

* Supports [validity periods](https://developers.cloudflare.com/ssl/reference/certificate-validity-periods/) of 14, 30, and 90 days. Enterprise customers using [advanced certificates](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) can also choose a validity period of one year.
* [DCV tokens](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/) are valid for 14 days.

#### Limitations

SSL.com DCV tokens are specific for RSA certificates and ECDSA certificates. This means that, for cases where you have to [manually perform DCV](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/#partial-dns-setup---action-sometimes-required), you will have to place two validation tokens per certificate order. To avoid management overhead, consider using a [full setup](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/#full-dns-setup---no-action-required), or setting up [Delegated DCV](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/delegated-dcv/).

#### Browser compatibility

Warning

This section summarizes commonly requested client support information. For the complete and most up-to-date certificate compatibility, refer to [SSL.com documentation](https://www.ssl.com/browser_compatibility/).

SSL.com is highly compatible, being accepted by over 99.9% of browsers, tablets, and mobile devices.

SSL.com certificates are [cross-signed with Certum](https://www.ssl.com/repository/) and the [CA that cross-signs intermediates](https://crt.sh/?caid=840) is from 2004.

#### Other resources

[Acceptable top level domains (TLDs) and current restrictions](https://www.ssl.com/acceptable-top-level-domains-tlds-for-ssl-certificates/)

***

### Sectigo

* Only used for [Backup certificates](https://developers.cloudflare.com/ssl/edge-certificates/backup-certificates/).
* Backup certificates are valid for 90 days.

#### Browser compatibility

Refer to [Sectigo documentation](https://www.sectigo.com/knowledge-base/detail/SSL-Browser-Compatibility-1527076085062/kA01N000000zFJt).

***

## CAA records

A Certificate Authority Authorization (CAA) DNS record specifies which certificate authorities (CAs) are allowed to issue certificates for a domain. This record reduces the chance of unauthorized certificate issuance and promotes standardization across your organization.



If you are using Cloudflare as your DNS provider, then the CAA records will be added on your behalf. If you need to add CAA records, refer to [Add CAA records](https://developers.cloudflare.com/ssl/edge-certificates/caa-records/).

The following table lists the CAA record content for each CA:

| Certificate authority | CAA record content |
| - | - |
| Let's Encrypt | `letsencrypt.org` |
| Google Trust Services | `pki.goog; cansignhttpexchanges=yes` |
| SSL.com | `ssl.com` |
| Sectigo | `sectigo.com` |
