---
title: DashButton · Cloudflare Style Guide
description: This component creates a LinkButton that links to a Cloudflare
  dashboard deeplink.
lastUpdated: 2025-09-25T15:07:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/dash-button/
  md: https://developers.cloudflare.com/style-guide/components/dash-button/index.md
---

This component creates a [LinkButton](https://developers.cloudflare.com/style-guide/components/buttons/) that links to a Cloudflare dashboard deeplink.

While we recommend the use of `DashButton`, you can continue to use deeplinks (as a link, without the component), if necessary.

Where routes are stored

The list of available routes are generated by running a script that we manually trigger periodically. The script outputs the available paths in [`src/content/dash-routes/index.json`](https://github.com/cloudflare/cloudflare-docs/blob/production/src/content/dash-routes/index.json).

The `DashButton` component then uses those routes to automatically generate the list of buttons on this page. The `DashButton` will fail to build if you edit the `url` prop to a route that is not listed in the `index.json` file.

Additionally, each run of the script overwrites the previous `/dash-routes/index.json` file. If you edit the this file manually, it will be overwritten in the next run of the script.

Therefore, only make manual changes to this file if both of the following are true:

* The link is already live in the dashboard.
* The name-change is confirmed, and there's no (or little) chance of rollback.

## Import

## Usage

## `<DashButton>` Props

### `url`

**type:** `string`

The Cloudflare dashboard deeplink to navigate to. See the below list for available routes.

## Available routes

* **Account home**

  ```mdx
  <DashButton url="/?to=/:account/home" />
  ```

* **Discover**

  ```mdx
  <DashButton url="/?to=/:account/discover" />
  ```

* **Domain registration > Manage domains**

  ```mdx
  <DashButton url="/?to=/:account/registrar/domains" />
  ```

* **Domain registration > Transfer domains**

  ```mdx
  <DashButton url="/?to=/:account/registrar/transfer" />
  ```

* **Domain registration > Register domains**

  ```mdx
  <DashButton url="/?to=/:account/registrar/register" />
  ```

* **Log Explorer**

  ```mdx
  <DashButton url="/?to=/:account/log-explorer" />
  ```

* **Log Explorer > Log search**

  ```mdx
  <DashButton url="/?to=/:account/log-explorer/log-search" />
  ```

* **Log Explorer > Custom dashboards**

  ```mdx
  <DashButton url="/?to=/:account/log-explorer/dashboards" />
  ```

* **Log Explorer > Manage datasets**

  ```mdx
  <DashButton url="/?to=/:account/log-explorer/manage-sources" />
  ```

* **Analytics & Logs > Account analytics**

  ```mdx
  <DashButton url="/?to=/:account/analytics" />
  ```

* **Analytics & Logs > Network analytics**

  ```mdx
  <DashButton url="/?to=/:account/network-analytics" />
  ```

* **Analytics & Logs > Web analytics**

  ```mdx
  <DashButton url="/?to=/:account/web-analytics" />
  ```

* **Analytics & Logs > Logpush**

  ```mdx
  <DashButton url="/?to=/:account/logs" />
  ```

* **Analytics & Logs > Carbon Impact Report**

  ```mdx
  <DashButton url="/?to=/:account/carbon" />
  ```

* **Magic Cloud Networking > Cloud on-ramps**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/cloud-onramp/list" />
  ```

* **Magic Cloud Networking > Address Space**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/configuration/magic_wan_address_space" />
  ```

* **Magic Cloud Networking > Cloud integrations**

  ```mdx
  <DashButton url="/?to=/:account/mcn/integrations" />
  ```

* **Analytics & Logs > Magic monitoring**

  ```mdx
  <DashButton url="/?to=/:account/network-monitoring" />
  ```

* **Security Center > Security insights**

  ```mdx
  <DashButton url="/?to=/:account/security-center" />
  ```

* **Security Center > Security analytics**

  ```mdx
  <DashButton url="/?to=/:account/security-center/analytics" />
  ```

* **Security Center > Security events**

  ```mdx
  <DashButton url="/?to=/:account/security-center/events" />
  ```

* **Security Center > Infrastructure**

  ```mdx
  <DashButton url="/?to=/:account/security-center/inventory" />
  ```

* **Security Center > Investigate**

  ```mdx
  <DashButton url="/?to=/:account/security-center/investigate" />
  ```

* **Security Center > Security reports**

  ```mdx
  <DashButton url="/?to=/:account/security-center/reports" />
  ```

* **Security Center > Brand Protection**

  ```mdx
  <DashButton url="/?to=/:account/security-center/brand-protection" />
  ```

* **Security Center > Threat intelligence**

  ```mdx
  <DashButton url="/?to=/:account/security-center/threat-intelligence" />
  ```

* **Trace**

  ```mdx
  <DashButton url="/?to=/:account/trace" />
  ```

* **WAF**

  ```mdx
  <DashButton url="/?to=/:account/application-security/waf" />
  ```

* **Internal DNS**

  ```mdx
  <DashButton url="/?to=/:account/internal-dns" />
  ```

* **DNS Firewall**

  ```mdx
  <DashButton url="/?to=/:account/dns-firewall" />
  ```

* **Turnstile**

  ```mdx
  <DashButton url="/?to=/:account/turnstile" />
  ```

* **Load balancing**

  ```mdx
  <DashButton url="/?to=/:account/load-balancing" />
  ```

* **Interconnects**

  ```mdx
  <DashButton url="/?to=/:account/interconnects" />
  ```

* **Magic Transit**

  ```mdx
  <DashButton url="/?to=/:account/magic-transit" />
  ```

* **Magic Transit > Configuration**

  ```mdx
  <DashButton url="/?to=/:account/magic-transit/configuration" />
  ```

* **Magic Transit > Network health**

  ```mdx
  <DashButton url="/?to=/:account/magic-transit/tunnel-healthchecks" />
  ```

* **Magic Transit > Packet captures**

  ```mdx
  <DashButton url="/?to=/:account/magic-transit/packet-captures/captures" />
  ```

* **Magic Firewall**

  ```mdx
  <DashButton url="/?to=/:account/network-security/magic_firewall" />
  ```

* **L3/4 DDoS protection > DDoS Managed Rules**

  ```mdx
  <DashButton url="/?to=/:account/network-security/ddos" />
  ```

* **IP addresses > Address maps**

  ```mdx
  <DashButton url="/?to=/:account/ip-addresses/proxy-ips" />
  ```

* **Zero Trust**

  ```mdx
  <DashButton url="https://one.dash.cloudflare.com" />
  ```

* **Magic WAN > Overview**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/overview" />
  ```

* **Magic WAN > Sites**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/sites" />
  ```

* **Magic WAN > Configuration**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/configuration" />
  ```

* **Magic WAN > Network health**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/tunnel-healthchecks" />
  ```

* **Magic WAN > Packet captures**

  ```mdx
  <DashButton url="/?to=/:account/magic-wan/packet-captures/captures" />
  ```

* **Compute (Workers) > Workers & Pages**

  ```mdx
  <DashButton url="/?to=/:account/workers-and-pages" />
  ```

* **Compute (Workers) > Durable Objects**

  ```mdx
  <DashButton url="/?to=/:account/workers/durable-objects" />
  ```

* **Compute (Workers) > Containers**

  ```mdx
  <DashButton url="/?to=/:account/workers/containers" />
  ```

* **Compute (Workers) > Observability**

  ```mdx
  <DashButton url="/?to=/:account/workers-and-pages/observability" />
  ```

* **Compute (Workers) > Workflows**

  ```mdx
  <DashButton url="/?to=/:account/workers/workflows" />
  ```

* **Compute (Workers) > Browser Rendering**

  ```mdx
  <DashButton url="/?to=/:account/workers/browser-rendering" />
  ```

* **Compute (Workers) > Workers plans**

  ```mdx
  <DashButton url="/?to=/:account/workers/plans" />
  ```

* **Secrets Store**

  ```mdx
  <DashButton url="/?to=/:account/secrets-store" />
  ```

* **Workers for Platforms**

  ```mdx
  <DashButton url="/?to=/:account/workers-for-platforms" />
  ```

* **Storage & Databases > Workers KV**

  ```mdx
  <DashButton url="/?to=/:account/workers/kv/namespaces" />
  ```

* **Storage & Databases > D1 SQL database**

  ```mdx
  <DashButton url="/?to=/:account/workers/d1" />
  ```

* **Storage & Databases > Hyperdrive**

  ```mdx
  <DashButton url="/?to=/:account/workers/hyperdrive" />
  ```

* **Storage & Databases > Pipelines**

  ```mdx
  <DashButton url="/?to=/:account/pipelines" />
  ```

* **Storage & Databases > Queues**

  ```mdx
  <DashButton url="/?to=/:account/workers/queues" />
  ```

* **Storage & Databases > Analytics Engine**

  ```mdx
  <DashButton url="/?to=/:account/workers/analytics-engine" />
  ```

* **R2 object storage > Overview**

  ```mdx
  <DashButton url="/?to=/:account/r2/overview" />
  ```

* **R2 object storage > Data migration**

  ```mdx
  <DashButton url="/?to=/:account/r2/slurper" />
  ```

* **AI > Workers AI**

  ```mdx
  <DashButton url="/?to=/:account/ai/workers-ai" />
  ```

* **AI > Vectorize**

  ```mdx
  <DashButton url="/?to=/:account/ai/vectorize" />
  ```

* **AI > AI Gateway**

  ```mdx
  <DashButton url="/?to=/:account/ai/ai-gateway" />
  ```

* **AI > AI Search**

  ```mdx
  <DashButton url="/?to=/:account/ai/ai-search" />
  ```

* **Stream**

  ```mdx
  <DashButton url="/?to=/:account/stream" />
  ```

* **Stream > Videos**

  ```mdx
  <DashButton url="/?to=/:account/stream/videos" />
  ```

* **Stream > Live inputs**

  ```mdx
  <DashButton url="/?to=/:account/stream/inputs" />
  ```

* **Stream > Transformations**

  ```mdx
  <DashButton url="/?to=/:account/stream/video-transformations" />
  ```

* **Stream > Analytics**

  ```mdx
  <DashButton url="/?to=/:account/stream/analytics" />
  ```

* **Images > Overview**

  ```mdx
  <DashButton url="/?to=/:account/images" />
  ```

* **Images > Variants**

  ```mdx
  <DashButton url="/?to=/:account/images/variants" />
  ```

* **Images > Keys**

  ```mdx
  <DashButton url="/?to=/:account/images/keys" />
  ```

* **Images > Sourcing kit**

  ```mdx
  <DashButton url="/?to=/:account/images/sourcing-kit" />
  ```

* **Images > Transformations**

  ```mdx
  <DashButton url="/?to=/:account/images/delivery-zones" />
  ```

* **Realtime**

  ```mdx
  <DashButton url="/?to=/:account/realtime" />
  ```

* **Realtime > Agents**

  ```mdx
  <DashButton url="/?to=/:account/realtime/agents" />
  ```

* **Realtime > RealtimeKit**

  ```mdx
  <DashButton url="/?to=/:account/realtime/kit" />
  ```

* **Realtime > TURN Server**

  ```mdx
  <DashButton url="/?to=/:account/realtime/turn" />
  ```

* **Realtime > Serverless SFU**

  ```mdx
  <DashButton url="/?to=/:account/realtime/sfu" />
  ```

* **Tag management**

  ```mdx
  <DashButton url="/?to=/:account/tag-management" />
  ```

* **Tag management > Tag setup**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/zaraz" />
  ```

* **Tag management > Consent**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/consent" />
  ```

* **Tag management > History**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/history" />
  ```

* **Tag management > Monitoring**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/monitoring" />
  ```

* **Tag management > Settings**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/settings" />
  ```

* **Tag management > Zaraz plans**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/plans" />
  ```

* **Tag management > Google Tag Gateway**

  ```mdx
  <DashButton url="/?to=/:account/tag-management/google-tag-gateway" />
  ```

* **Manage Account > Members**

  ```mdx
  <DashButton url="/?to=/:account/members" />
  ```

* **Manage Account Members Settings > Members Settings**

  ```mdx
  <DashButton url="/?to=/:account/members/settings" />
  ```

* **Manage Account > Account API tokens**

  ```mdx
  <DashButton url="/?to=/:account/api-tokens" />
  ```

* **Manage Account > Audit logs**

  ```mdx
  <DashButton url="/?to=/:account/audit-log" />
  ```

* **Manage Account > Billing**

  ```mdx
  <DashButton url="/?to=/:account/billing" />
  ```

* **Manage Account > Settings**

  ```mdx
  <DashButton url="/?to=/:account/configurations" />
  ```

* **Manage Account > Abuse reports**

  ```mdx
  <DashButton url="/?to=/:account/abuse-reports" />
  ```

* **Manage Account > Blocked content**

  ```mdx
  <DashButton url="/?to=/:account/blocked-content" />
  ```

* **Notifications**

  ```mdx
  <DashButton url="/?to=/:account/notifications" />
  ```

* **Bulk redirects**

  ```mdx
  <DashButton url="/?to=/:account/bulk-redirects" />
  ```

* **Domain management > Overview**

  ```mdx
  <DashButton url="/?to=/:account/domains/overview" />
  ```

* **Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/" />
  ```

* **AI Crawl Control**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ai" />
  ```

* **Log Explorer**

  ```mdx
  <DashButton url="/?to=/:account/:zone/log-explorer" />
  ```

* **Log Explorer > Log search**

  ```mdx
  <DashButton url="/?to=/:account/:zone/log-explorer/log-search" />
  ```

* **Log Explorer > Custom dashboards**

  ```mdx
  <DashButton url="/?to=/:account/:zone/log-explorer/dashboards" />
  ```

* **Log Explorer > Manage datasets**

  ```mdx
  <DashButton url="/?to=/:account/:zone/log-explorer/manage-sources" />
  ```

* **Analytics & Logs**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics" />
  ```

* **Analytics & Logs > HTTP Traffic**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/traffic" />
  ```

* **Analytics & Logs > Web analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/web/overview" />
  ```

* **Analytics & Logs > Security**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/security" />
  ```

* **Analytics & Logs > Performance**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/performance" />
  ```

* **Analytics & Logs > Edge Reachability**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/edgeReachability" />
  ```

* **Analytics & Logs > Workers**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/workers" />
  ```

* **Analytics & Logs > Logpush**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/logs" />
  ```

* **Analytics & Logs > Instant Logs**

  ```mdx
  <DashButton url="/?to=/:account/:zone/analytics/instant-logs" />
  ```

* **Version Management**

  ```mdx
  <DashButton url="/?to=/:account/:zone/versioning" />
  ```

* **DNS**

  ```mdx
  <DashButton url="/?to=/:account/:zone/dns" />
  ```

* **DNS > Records**

  ```mdx
  <DashButton url="/?to=/:account/:zone/dns/records" />
  ```

* **DNS > Analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/dns/analytics" />
  ```

* **DNS > Settings**

  ```mdx
  <DashButton url="/?to=/:account/:zone/dns/settings" />
  ```

* **Email**

  ```mdx
  <DashButton url="/?to=/:account/:zone/email" />
  ```

* **Email > Email Routing**

  ```mdx
  <DashButton url="/?to=/:account/:zone/email/routing" />
  ```

* **Email > DMARC Management**

  ```mdx
  <DashButton url="/?to=/:account/:zone/email/dmarc-management" />
  ```

* **Email > Email Security**

  ```mdx
  <DashButton url="/?to=/:account/:zone/email/security" />
  ```

* **Spectrum**

  ```mdx
  <DashButton url="/?to=/:account/:zone/spectrum" />
  ```

* **SSL/TLS > Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls" />
  ```

* **SSL/TLS > Edge Certificates**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/edge-certificates" />
  ```

* **SSL/TLS > Staging Certificates**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/staging-certificates" />
  ```

* **SSL/TLS > Client Certificates**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/client-certificates" />
  ```

* **SSL/TLS > Origin Server**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/origin" />
  ```

* **SSL/TLS > Custom Hostnames**

  ```mdx
  <DashButton url="/?to=/:account/:zone/ssl-tls/custom-hostnames" />
  ```

* **Security**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security" />
  ```

* **Security > Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/overview" />
  ```

* **Security > Analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/analytics" />
  ```

* **Security > Web assets**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/web-assets" />
  ```

* **Security > Security rules**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/security-rules" />
  ```

* **Security > Settings**

  ```mdx
  <DashButton url="/?to=/:account/:zone/security/settings" />
  ```

* **Access**

  ```mdx
  <DashButton url="/?to=/:account/:zone/access" />
  ```

* **Speed**

  ```mdx
  <DashButton url="/?to=/:account/:zone/speed" />
  ```

* **Speed > Synthetic monitoring**

  ```mdx
  <DashButton url="/?to=/:account/:zone/speed/test" />
  ```

* **Speed > Settings**

  ```mdx
  <DashButton url="/?to=/:account/:zone/speed/optimization" />
  ```

* **Caching > Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching" />
  ```

* **Caching > Configuration**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching/configuration" />
  ```

* **Caching > Cache Rules**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching/cache-rules" />
  ```

* **Caching > Tiered Cache**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching/tiered-cache" />
  ```

* **Caching > Cache Reserve**

  ```mdx
  <DashButton url="/?to=/:account/:zone/caching/cache-reserve" />
  ```

* **Workers Routes**

  ```mdx
  <DashButton url="/?to=/:account/:zone/workers" />
  ```

* **Rules**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules" />
  ```

* **Rules > Overview**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/overview" />
  ```

* **Rules > Snippets**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/snippets" />
  ```

* **Rules > Cloud Connector**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/cloud-connector" />
  ```

* **Rules > Trace**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/trace/search" />
  ```

* **Rules > Page Rules**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/page-rules" />
  ```

* **Rules > Settings**

  ```mdx
  <DashButton url="/?to=/:account/:zone/rules/settings" />
  ```

* **Error Pages**

  ```mdx
  <DashButton url="/?to=/:account/:zone/error-pages" />
  ```

* **Network**

  ```mdx
  <DashButton url="/?to=/:account/:zone/network" />
  ```

* **Traffic > Argo Smart Routing**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic" />
  ```

* **Traffic > Load balancing**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/load-balancing" />
  ```

* **Traffic > Load Balancing Analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/load-balancing-analytics" />
  ```

* **Traffic > Health Checks**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/health-checks" />
  ```

* **Traffic > Health Check Analytics**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/health-check-analytics" />
  ```

* **Traffic > Waiting Room**

  ```mdx
  <DashButton url="/?to=/:account/:zone/traffic/waiting-rooms" />
  ```

* **Scrape Shield**

  ```mdx
  <DashButton url="/?to=/:account/:zone/content-protection" />
  ```

* **Web3**

  ```mdx
  <DashButton url="/?to=/:account/:zone/web3" />
  ```
