---
title: Links · Cloudflare Style Guide
description: A link is a reference to another page, part of a page, or external resource.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/links/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/links/index.md
---

A link is a reference to another page, part of a page, or external resource.

Hyperlinks are incredibly useful but - if overdone - can be distracting.

## Types of links

There are 3 types of links:

* **External**: To other resources, such as [www.cloudflare.com](http://www.cloudflare.com).
* **Internal**: To other pages in the docs, such as [Workers](https://developers.cloudflare.com/workers/).
* **Anchor**: To specific parts of other pages in our docs, such as [Proxied records](https://developers.cloudflare.com/dns/proxy-status/#proxied-records).

## Guidance for inline paragraph links

Avoid non-descriptive link text like: `click here` and `this page`; instead, use the actual title of the target page or an abbreviated version of that title. This is also important so that readers see that when they get there, they actually linked to the page they intended to visit.

Use unique link text. Speech recognition software does not handle duplicated link text well.

Use in-paragraph links only if they are internal (those within Cloudflare's websites) and if the material relates directly to what's being described. In other words, will the content behind the link help the reader make a decision or accomplish something before continuing to read the current document?

Avoid directional language.

## Links for the Related resources section

Use a *Related resources* section at the end of your document for:

* Internal links that loosely relate to the topic or offer a chance for deeper learning
* All external links (not residing in Cloudflare's websites)
* Internal and external links that represent the next logical steps to follow

External links placed in-paragraph are strongly discouraged because Cloudflare has no control over them. For example, if a link no longer resolves, our content feels less reliable. By shifting all external links to the end of the document, the impact of a broken link is less dramatic.

## Links for instructions in documentation

Place links for example requests and API calls in code blocks.

Use placeholders in links with account- or user-specific information. And explain what to replace the referential text with.

* For example, for the link "`https://api.cloudflare.com/client/v4/accounts/a0b1c2d3/rulesets`" use "`https://api.cloudflare.com/client/v4/accounts/<ACCOUNTID>/rulesets`" and add text to say "replace `<ACCOUNTID>` with your Account ID" or similar.

See [angle brackets](https://developers.cloudflare.com/style-guide/formatting/code-conventions-and-format/) in Code Conventions and Formatting.

## Maintenance

For more details on how we handle link maintenance, refer to [Link maintenance](https://developers.cloudflare.com/style-guide/how-we-docs/links/).
