---
title: Error 10052 · Cloudflare Support docs
description: This error indicates that the source URL includes an unsupported port.
lastUpdated: 2025-05-16T13:10:20.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-10xxx-errors/error-10052/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-10xxx-errors/error-10052/index.md
---

## Error 10052: Invalid redirect source URL with port

This error indicates that the source URL includes an unsupported port.

### Common causes

This error occurs when the source URL of a URL redirect includes a port (for example, `https://example.com:8081`), which is not supported. Possible causes include using a custom or non-standard port, copying a URL from another environment that includes a port, or mistakenly using a development or testing URL.

### Resolution

Remove the port from the redirect source URL. Refer to [Supported URL components in Bulk Redirects](https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/reference/url-components/) for details on the supported URL components for redirect source URLs.
