---
title: Migrate from hCaptcha · Cloudflare Turnstile docs
description: If you are using hCaptcha today, you can switch seamlessly to
  Cloudflare Turnstile by following the step-by-step guide below to assist with
  the upgrade process.
lastUpdated: 2025-09-04T15:24:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/turnstile/migration/hcaptcha/
  md: https://developers.cloudflare.com/turnstile/migration/hcaptcha/index.md
---

If you are using hCaptcha today, you can switch seamlessly to Cloudflare Turnstile by following the step-by-step guide below to assist with the upgrade process.

To complete the migration, you must obtain the [sitekey and secret key](https://developers.cloudflare.com/turnstile/get-started/#get-a-sitekey-and-secret-key).

## Client-side integration

1. Update the client-side integration by inserting the Turnstile script snippet in your HTML's `<head>` element:

   ```html
   <script src="https://challenges.cloudflare.com/turnstile/v0/api.js" async defer></script>
   ```

2. Locate the `hcaptcha.render()` calls and replace the sitekey with your Turnstile sitekey and the API.

   ```js
   // before
   hcaptcha.render(element, {
       sitekey: "00000000-0000-0000-0000-000000000000"
   })
   // after
   turnstile.render(element, {
       sitekey: "1x00000000000000000000AA"
   })
   ```

Note

Turnstile supports:

* the `render()` call
* hCaptcha invisible mode with the `execute()` call

## Server-side integration

1. Update the server-side integration by replacing the Siteverify URL.

   Replace: `https://hcaptcha.com/siteverify` with the following:

   ```txt
   https://challenges.cloudflare.com/turnstile/v0/siteverify
   ```

2. Replace the `h-captcha-response` input name with the following:

   ```txt
   cf-turnstile-response
   ```
