---
title: WARP modes · Cloudflare WARP client docs
description: The WARP client has several modes to better suit different connection needs.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/warp-client/warp-modes/
  md: https://developers.cloudflare.com/warp-client/warp-modes/index.md
---

The WARP client has several modes to better suit different connection needs.

## 1.1.1.1

1.1.1.1 is Cloudflare’s public DNS resolver. It offers a fast and private way to browse the Internet. It also offers a DNS encryption service through DNS over HTTPS (DoH) or DNS over TLS (DoT) for increased security and privacy.

Refer to [1.1.1.1 resolver](https://developers.cloudflare.com/1.1.1.1/encryption/) to learn more about DNS encryption.

## 1.1.1.1 with WARP

The WARP application uses [MASQUE](https://blog.cloudflare.com/zero-trust-warp-with-a-masque/) to encrypt and send traffic from your device directly to Cloudflare's global network. This ensures Internet traffic between your device and the Internet is secure and private, while also preventing third parties from accessing your traffic. All traffic[1](#user-content-fn-1) tunneled over the MASQUE connection is encrypted using [post-quantum cryptography](https://blog.cloudflare.com/post-quantum-zero-trust/) to protect against [harvest-now-decrypt-later attacks](https://www.nist.gov/cybersecurity/what-post-quantum-cryptography).

If the site you are visiting is already a Cloudflare customer, the content is immediately sent to your device. If not, Cloudflare uses its global network of data centers to devise the shortest path to the site. For more information, refer to our blog post [Introducing WARP: Fixing Mobile Internet Performance and Security](https://blog.cloudflare.com/1111-warp-better-vpn/).

Warning

WARP does not provide anonymity, and it is not designed to prevent servers you communicate with from identifying you. WARP also does not allow you to pretend to be accessing the Internet from a different country.

## WARP via Local Proxy

Currently, this mode is available on desktop clients only. When WARP is configured as a local proxy, only the applications that you configure to use the proxy (HTTPS or SOCKS5) will have their traffic sent through WARP. This allows you to pick and choose which traffic is encrypted — for example, your web browser or a specific application. Everything else will not be encrypted and will be sent over a regular Internet connection.

Because this feature restricts WARP to just applications configured to use the local proxy, leaving all other traffic over the Internet unencrypted by default, we have hidden it in the **Advanced** menu. To turn it on:

1. Navigate to **Preferences** > **Advanced** and select **Configure Proxy**.
2. On the window that opens, check the box and configure the port you want to listen on.

This will enable the **WARP via Local Proxy** option in the **WARP Settings** menu.

If you enable [FIPS compliance](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#fips-compliance) for TLS decryption, you must [disable QUIC](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/http3/#force-http2-traffic) in your users' browsers. Otherwise, HTTP/3 traffic will bypass inspection by the WARP client.

## WARP+ Unlimited

While WARP can take advantage of the many Cloudflare data centers around the world to give you a more private and robust connection, WARP+ Unlimited subscribers get access to a larger network. More cities to connect to means you are likely to be closer to a Cloudflare data center, which can reduce latency and improve your browsing speed.

WARP+ Unlimited is a paid, monthly subscription that can be purchased via the Apple App Store or Google Play Store.

To subscribe to WARP+ Unlimited:

1. On an iOS or Android device, launch the **1.1.1.1: Faster Internet** app.
2. Select **Settings** > **Upgrade to WARP+**. A dialog will appear with the subscription price.
3. To confirm your subscription, select **Subscribe to WARP+ Unlimited**. All payments are handled by the Apple/Google app store, and the payment information associated with your Apple/Google account will be charged for these subscriptions.

WARP+ Unlimited is now active on this device. You can use your license key on up to five devices.

## Footnotes

1. Post-quantum cryptography requires the following minimum WARP versions:\
   **Android**: 2.4.3\
   **iOS**: 1.11.1\
   **Windows, macOS, and Linux**: 2025.6.1335.0 [↩](#user-content-fnref-1)
