---
title: Advanced setups · Cloudflare Workers docs
description: Learn how to use Workers Builds with more advanced setups
lastUpdated: 2025-10-01T16:43:03.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/ci-cd/builds/advanced-setups/
  md: https://developers.cloudflare.com/workers/ci-cd/builds/advanced-setups/index.md
---

## Monorepos

A monorepo is a single repository that contains multiple applications. This setup can be useful for a few reasons:

* **Simplified dependency management**: Manage dependencies across all your workers and shared packages from a single place using tools like [pnpm workspaces](https://pnpm.io/workspaces) and [syncpack](https://www.npmjs.com/package/syncpack).
* **Code sharing and reuse**: Easily create and share common logic, types, and utilities between workers by creating shared packages.
* **Atomic commits**: Changes affecting multiple workers or shared libraries can be committed together, making the history easier to understand and reducing the risk of inconsistencies.
* **Consistent tooling**: Apply the same build, test, linting, and formatting configurations (e.g., via [Turborepo](https://turborepo.com) in for task orchestration and shared configs in `packages/`) across all projects, ensuring consistent tooling and code quality across Workers.
* **Easier refactoring**: Refactoring code that spans multiple Workers or shared packages is significantly easier within a single repository.

#### Example Workers monorepos:

* [cloudflare/mcp-server-cloudflare](https://github.com/cloudflare/mcp-server-cloudflare)
* [jahands/workers-monorepo-template](https://github.com/jahands/workers-monorepo-template)
* [cloudflare/templates](https://github.com/cloudflare/templates)
* [cloudflare/workers-sdk](https://github.com/cloudflare/workers-sdk)

### Getting Started

To set up a monorepo workflow:

1. Find the Workers associated with your project in the [Workers & Pages Dashboard](https://dash.cloudflare.com).
2. Connect your monorepo to each Worker in the repository.
3. Set the root directory for each Worker to specify the location of its `wrangler.toml` and where build and deploy commands should run.
4. Optionally, configure unique build and deploy commands for each Worker.
5. Optionally, configure [build watch paths](https://developers.cloudflare.com/workers/ci-cd/builds/build-watch-paths/) for each Worker to monitor specific paths for changes.

When a new commit is made to the monorepo, a new build and deploy will trigger for each Worker if the change is within each of its included watch paths. You can also check on the status of each build associated with your repository within GitHub with [check runs](https://developers.cloudflare.com/workers/ci-cd/builds/git-integration/github-integration/#check-run) or within GitLab with [commit statuses](https://developers.cloudflare.com/workers/ci-cd/builds/git-integration/gitlab-integration/#commit-status).

### Example

In the example `ecommerce-monorepo`, a Workers project should be created for `product-service`, `order-service`, and `notification-service`.

A Git connection to `ecommerce-monorepo` should be added in all of the Workers projects. If you are using a monorepo tool, such as [Turborepo](https://turbo.build/), you can configure a different deploy command for each Worker, for example, `turbo deploy -F product-service`.

Set the root directory of each Worker to where its wrangler.toml is located. For example, for `product-service`, the root directory should be `/workers/product-service/`. Optionally, you can add [build watch paths](https://developers.cloudflare.com/workers/ci-cd/builds/build-watch-paths/) to optimize your builds.

When a new commit is made to `ecommerce-monorepo`, a build and deploy will be triggered for each of the Workers if the change is within its included watch paths using the configured commands for that Worker.

## Wrangler Environments

You can use [Wrangler Environments](https://developers.cloudflare.com/workers/wrangler/environments/) with Workers Builds by completing the following steps:

1. [Deploy via Wrangler](https://developers.cloudflare.com/workers/wrangler/commands/#deploy) to create the Workers for your environments on the Dashboard, if you do not already have them.
2. Find the Workers for your environments. They are typically named `[name of Worker] - [environment name]`.
3. Connect your repository to each of the Workers for your environment.
4. In each of the Workers, edit your Wrangler commands to include the flag `--env: <environment name>` in the build configurations for both the deploy command, and the non-production branch deploy command ([if applicable](https://developers.cloudflare.com/workers/ci-cd/builds/build-branches/#configure-non-production-branch-builds)).

When a new commit is detected in the repository, a new build/deploy will trigger for each associated Worker.

### Example

Imagine you have a Worker named `my-worker`, and you want to set up two environments `staging` and `production` set in the `wrangler.jsonc`. If you have not already, you can deploy `my-worker` for each environment using the commands `wrangler deploy --env staging` and `wrangler deploy --env production`.

In your Cloudflare Dashboard, you should find the two Workers `my-worker-staging` and `my-worker-production`. Then, connect the Git repository for the Worker, `my-worker`, to both of the environment Workers. In the build configurations of each environment Worker, edit the deploy commands to be `npx wrangler deploy --env staging` and `npx wrangler deploy --env production` and the non-production branch deploy commands to be `npx wrangler versions upload --env staging` and `npx wrangler versions upload --env production` respectively.
